/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.internal.dialogs.FiltersTabUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class FiltersStandardTabUI extends FiltersTabUI {

	/**
	 * Creates the control UI for the standard tab given the Composite parent.
	 */
	public abstract Control createControl(Composite parent);

	/**
	 * This method is called when the tab UI is loaded or shown.  The UI
	 * is to populate its data for a dialog loading with the given SimpleSearchQuery filter.
	 */
	public abstract void initializeFrom(SimpleSearchQuery filter);
	
	/**
	 * This method is called to apply the filter information of this UI on the given filter.
	 */
	public abstract SimpleSearchQuery performApply();
	
	/**
	 * 
	 * Returns the tab name that is displayed in the filters dialog.
	 */
	public String getTabName()
	{
		return UIPlugin.getResourceString("FILTERS_DIALOG_STANDARD_TAB");
	}

	/**
	 * 
	 * Returns the tab image that is displayed in the filters dialog.
	 */
	public Image getTabImage()
	{
		return PDPluginImages.getImage(PDPluginImages.IMG_VIEW_FILTER_OBJ);	
	}
	
}
