/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;

public interface IFilterQueryProvider {

	/**
	 * 
	 * Returns a merged filter with the standard tab query and advanced tab query. 
	 */	
	public SimpleSearchQuery getCurrentFilter();

	/**
	 * 
	 * Returns the standard tab Query. 
	 */	
	public SimpleSearchQuery standardQuery();
	
	/**
	 * 
	 * Returns the advanced tab Query. 
	 */	
	public SimpleSearchQuery advancedQuery();

	/**
	 * 
	 * Updates the standard tab Query with the given Query and
	 * opens the filter dialog on the standard tab.
	 */		
	public void updateStandardQuery(SimpleSearchQuery standardQuery);
	
	/**
	 * 
	 * Updates the advanced tab Query with the given Query and
	 * opens the filter dialog on the advanced tab. 
	 */			
	public void updateAdvancedQuery(SimpleSearchQuery advancedQuery);
	
	/**
	 * 
	 * Updates the advanced tab Query with the given Query and
	 * opens the filter dialog on the advanced tab, and selects the row
	 * given in the parameters (int advancedTabSelectionIndex).
	 */				
	public void updateAdvancedQuery(SimpleSearchQuery advancedQuery, int advancedTabSelectionIndex);	
	
	/**
	 * 
	 * This method must be called with IFilterViewer is disposed, so that
	 * the viewer can be dropped from the internal filter update listeners.
	 */
	public void viewerDisposed();
}
