/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters;


/**
 *
 * The viewer associated with filters.  It's fully qualified class name
 * is used to retrieve its associated type descriptions, that are defined in
 * the analyzerExtensions extention point through the IViewerRunnable interface. 
 */
public interface IFilterViewer {
	
	/**
	 * 
	 * When a filter is selected, a filter update is called with the filter selected
	 * so that the viewer can in turn update its view.
	 */
	public void filterUpdated();
	
	
	/**
	 * 
	 * When the action is created, this method is called providing the filter query provider
	 * for the viewer if it changes the standard/advanced tab
	 */
	public void setFilterQueryProvider(IFilterQueryProvider filterQueryProvider);


	/**
	 * 
	 * Returns the filter scope associated with the IFilterViewer implementor.
	 */
	public String[] getFilterScope();
}
