/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.filters.internal.actions;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.ui.filters.internal.dialogs.FilterTypeDialog;
import org.eclipse.hyades.trace.ui.filters.internal.dialogs.FilterUIUtil;
import org.eclipse.hyades.trace.ui.filters.internal.dialogs.FiltersDialog;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.trace.ui.internal.filters.IFilterType;

public class CreateOrEditFilter {

	
	public static void run(FilterInformationManager fi, String selectedFilterName)
	{
		run(fi, 0, null, null, -1, selectedFilterName);
	}
	
	public static void run(FilterInformationManager fi)
	{
		run(fi, 0, null, null, -1, fi.selectedFilterName());
	}		

	public static void run(FilterInformationManager fi, int openTabIndex, SimpleSearchQuery standardTabQuery, SimpleSearchQuery advancedTabQuery, int advancedTabSelectionIndex, String selectedFilterName)
	{
		run(fi, openTabIndex, standardTabQuery, advancedTabQuery, advancedTabSelectionIndex, selectedFilterName!=null?fi.filter(selectedFilterName):null);		
	}
	

	public static void run(FilterInformationManager fi, int openTabIndex, SimpleSearchQuery standardTabQuery, SimpleSearchQuery advancedTabQuery, int advancedTabSelectionIndex)
	{
		run(fi, openTabIndex, standardTabQuery, advancedTabQuery, advancedTabSelectionIndex, fi.selectedFilter());
	}	
	
	public static void run(FilterInformationManager fi, int openTabIndex, SimpleSearchQuery standardTabQuery, SimpleSearchQuery advancedTabQuery, int advancedTabSelectionIndex, FilterQueries selectedFilter)
	{
		FilterQueries filter = selectedFilter;
		FilterQueries changedFilter = null;		
		
		if (filter == null)
		{
			FilterTypeDialog filterTypeDialog = FilterUIUtil.getFiltersTypeDialog(fi);
			filterTypeDialog.open();
			
			IFilterType type = filterTypeDialog.selectedFilterType();

			if (type == null)
				return;
				
			changedFilter = fi.createFilterQueries(type.id(), standardTabQuery, advancedTabQuery);
		}
		else
		{
			changedFilter = filter.copy();
			
			if (standardTabQuery != null)
				filter.standard(standardTabQuery);
			
			if (advancedTabQuery != null)
				filter.advanced(advancedTabQuery);
		}
		

		FiltersDialog filtersDialog = FilterUIUtil.getFiltersDialog(changedFilter, fi, openTabIndex, advancedTabSelectionIndex);
		filtersDialog.open();
		
		if (filtersDialog.getReturnCode() == FiltersDialog.OK)
		{
			if (filter != null)
				fi.removeFilter(filter);
				
			fi.addFilter(changedFilter);
			
			fi.selectedFilterName(changedFilter.name());
			fi.save();
		}
		else
		{
			fi.restore();
		}		
	}
}
