/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters.internal.actions;

import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.ui.filters.IFilterQueryProvider;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterQueries;

public class FilterQueryProvider implements IFilterQueryProvider
{
	private FilterInformationManager _fi;
	
	public FilterQueryProvider(FilterInformationManager fi)
	{
		_fi = fi;
	}

	public SimpleSearchQuery standardQuery() {
		FilterQueries fq = _fi.selectedFilter();
		
		if (fq != null)
		{
			return fq.standard();
		}
		else
		{
			SimpleSearchQuery query = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
			LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
			query.setWhereExpression(logicalExpression);
			
			return query;
		}
	}

	public SimpleSearchQuery advancedQuery() {
		FilterQueries fq = _fi.selectedFilter();
		
		if (fq != null)
		{
			return fq.advanced();
		}
		else
		{
			SimpleSearchQuery query = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
			LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
			query.setWhereExpression(logicalExpression);
			
			return query;
		}
	}

	public void updateStandardQuery(SimpleSearchQuery standardQuery) {
		CreateOrEditFilter.run(_fi, 0, standardQuery, null, -1);
	}

	public void updateAdvancedQuery(SimpleSearchQuery advancedQuery) {
		CreateOrEditFilter.run(_fi, 1, null, advancedQuery, -1);
	}
	
	public void updateAdvancedQuery(SimpleSearchQuery advancedQuery, int advancedTabSelectionIndex) {
		CreateOrEditFilter.run(_fi, 1, null, advancedQuery, advancedTabSelectionIndex);
	}

	public SimpleSearchQuery getCurrentFilter() {
		return _fi.getCurrentFilter();
	}

	public void viewerDisposed() {
		_fi.viewerDisposed();
	}
}
