/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.filters.internal.actions;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.trace.ui.internal.filters.FilterTypesManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;


public class FiltersDropDownMenu implements IMenuCreator {

	/**
	 * Cascading menu 
	 */
	private Menu _menu;
	private FiltersEditorAction _feAction;
	private FilterInformationManager _fi;
	
	public FiltersDropDownMenu(FilterInformationManager fi)
	{
		super();

		_fi = fi;		
		_feAction = new FiltersEditorAction(_fi);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IMenuCreator#dispose()
	 */
	public void dispose() {
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IMenuCreator#getMenu(org.eclipse.swt.widgets.Control)
	 */
	public Menu getMenu(Control parent) {
		if (_menu != null) {
			_menu.dispose();
		}
		_menu= new Menu(parent);
		boolean noActionSelected = true;
		
		for (int i= 0; i < _fi.size(); i++) {
			FiltersSetAction action= new FiltersSetAction(this, _fi.filter(i).name(), FilterTypesManager.instance().getFilterType(_fi.filter(i).type()).icon());
			
			if (_fi.selectedFilterName() != null
					&& _fi.selectedFilterName().equals(action.getText()))
			{
				action.setChecked(true);
				noActionSelected = false;				
			}
			else
				action.setChecked(false);
			
			addActionToMenu(_menu, action);
		}

		FiltersSetAction action= new FiltersSetAction(this, UIPlugin.getResourceString("STR_DROPDOWN_NO_FILTER"), null);
		
		if (noActionSelected)
		{
			_fi.selectedFilterName(null, false);
			action.setChecked(true);
		}
		else
		{
			action.setChecked(false);
		}
		
		addActionToMenu(_menu, action);
		
		(new Separator()).fill(_menu, -1);
		
		addActionToMenu(_menu, _feAction);		
		
		return _menu;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IMenuCreator#getMenu(org.eclipse.swt.widgets.Menu)
	 */
	public Menu getMenu(Menu parent) {
		return null;
	}
	
	protected void addActionToMenu(Menu parent, Action action) {
		ActionContributionItem item= new ActionContributionItem(action);
		item.fill(parent, -1);
	}	
	
	public void selectedFilterName(String filterName)
	{
		_fi.selectedFilterName(filterName);
	}	
}
