/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.filters.internal.actions;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.internal.dialogs.FilterUIUtil;
import org.eclipse.hyades.trace.ui.filters.internal.dialogs.FiltersEditDialog;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;


public class FiltersEditorAction extends Action {
	
	private FilterInformationManager _fi;
	
	public FiltersEditorAction(FilterInformationManager fi) {
		super("");

		_fi = fi;
		
		setText(UIPlugin.getResourceString("STR_DROPDOWN_EDIT_FILTERS"));
		PDPluginImages.setImageDescriptors(this, PDPluginImages.T_LCL, PDPluginImages.IMG_VIEW_FILTER);
		
		setEnabled(true);
	}
	
	public void run() {
		FiltersEditDialog filtersEditDlg = FilterUIUtil.getFiltersEditDialog(_fi);
		filtersEditDlg.selectedFilterName(_fi.selectedFilterName());
		filtersEditDlg.open();
		
		if (filtersEditDlg.getReturnCode() == FiltersEditDialog.OK)
		{
			//if (filtersEditDlg.selectedFilterName() != null)
			_fi.selectedFilterName(filtersEditDlg.selectedFilterName());
		}
	}
	
	public void run(IAction action) {
		run();
	}
	
	public void setInitializationData(
		IConfigurationElement configElement,
		String name,
		Object data) {
	}
	
	public void selectionChanged(IAction action, ISelection selection) {
	}

	public void dispose() {
	}

	public void init(IWorkbenchWindow window) {
	}
	
	public void init(IViewPart view) {
	}

}
