/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters.internal.dialogs;

import org.eclipse.hyades.trace.ui.filters.IFilterAttribute;

public class FilterElement {
	private IFilterAttribute _attribute;
	private String _operator;
	private String _value;
	
	public FilterElement(IFilterAttribute attribute, String operator, String value)
	{
		_attribute = attribute;
		_operator = operator;
		_value = value;
	}
	
	public IFilterAttribute attribute()
	{
		return _attribute;
	}
	
	public String operator()
	{
		return _operator;
	}
	
	public String value()
	{
		return _value;
	}
	
	public void setAttribute(IFilterAttribute attribute)
	{
		_attribute = attribute;
	}
	
	public void setOperator(String operator)
	{
		_operator = operator;
	}
	
	public void setValue(String value)
	{
		_value = value;
	}	
}
