/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters.internal.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import org.eclipse.hyades.trace.ui.filters.IFilterViewer;
import org.eclipse.hyades.trace.ui.internal.filters.FilterTypesManager;
import org.eclipse.hyades.trace.ui.internal.filters.IFilterType;

public class ScopeContainer {

	private static ScopeContainer _instance = null;
	
	private Map _scopeSelectedFilter;
	private Map _scopeViewers;
	private Map _viewerSelectedScope;
	
	protected ScopeContainer()
	{
		_scopeSelectedFilter = new HashMap();
		_scopeViewers = new HashMap();
		_viewerSelectedScope = new HashMap();
	}
	
	public static ScopeContainer instance()
	{
		if (_instance == null)
			_instance = new ScopeContainer();
		
		return _instance;
	}
	
	public String getSelectedFilterName(String scope)
	{
		return (String)_scopeSelectedFilter.get(scope);
	}
	
	public String[] setSelectedFilterName(String selectedFilterName)
	{
		FilterQueries fq = FilterResourceHandler.instance().filter(selectedFilterName);
		
		if (fq != null)
		{
			IFilterType filterType = FilterTypesManager.instance().getFilterType(fq.type());
			
			String[] scope = filterType.scope();
			for (int i = 0; i < scope.length; i++)
				setSelectedFilterName(scope[i], selectedFilterName);
			
			return scope;
		}
		
		return null;
	}
	
	public void setSelectedFilterName(String scope, String selectedFilterName)
	{
		_scopeSelectedFilter.put(scope, selectedFilterName);
	}	
	
	public void addFilterViewer(IFilterViewer viewer)
	{
		if (viewer == null)
			return;
		
		String[] scope = viewer.getFilterScope();
		
		if (scope == null)
			return;
		
		for (int i = 0; i < scope.length; i++)
		{
			addFilterViewer(scope[i], viewer);
		}
	}
	
	private void addFilterViewer(String scope, IFilterViewer viewer)
	{
		Vector viewersV = (Vector)_scopeViewers.get(scope);
		
		if (viewersV == null)
		{
			viewersV = new Vector();
			_scopeViewers.put(scope, viewersV);
		}
		
		if (!vectorContainersObject(viewersV, viewer))
			viewersV.addElement(viewer);
	}
	
	private boolean vectorContainersObject(Vector v, Object obj)
	{
		for (int i = 0; i < v.size(); i++)
		{
			if (v.elementAt(i) == obj)
				return true;
		}
		
		return false;
	}
	
	public void removeFilterViewer(IFilterViewer viewer)
	{
		if (viewer == null)
			return;
		
		String[] scope = viewer.getFilterScope();
		
		if (scope == null)
			return;
		
		for (int i = 0; i < scope.length; i++)
		{
			removeFilterViewer(scope[i], viewer);
		}		
	}
	
	private void removeFilterViewer(String scope, IFilterViewer viewer)
	{
		Vector viewersV = (Vector)_scopeViewers.get(scope);
		
		if (viewersV == null)
			return;
		
		viewersV.remove(viewer);
	}	

	public IFilterViewer[] getFilterViewers(String scope)
	{
		Vector viewersV = (Vector)_scopeViewers.get(scope);
		
		if (viewersV == null)
			return new IFilterViewer[0];
		
		IFilterViewer[] viewers = new IFilterViewer[viewersV.size()];
		
		viewersV.toArray(viewers);
		
		return viewers;
	}
	
	public void setSelectedScope(String viewer, String selectedScope)
	{
		_viewerSelectedScope.put(viewer, selectedScope);
	}	

	public String getSelectedScope(String viewer)
	{
		return (String)_viewerSelectedScope.get(viewer);
	}	
	
	public String[] scopes()
	{
		Set scopeKeys = _scopeSelectedFilter.keySet();
		String[] scopes = new String[scopeKeys.size()];
		scopeKeys.toArray(scopes);
		
		return scopes;
	}
	
	public String[] viewers()
	{
		Set viewerKeys = _viewerSelectedScope.keySet();
		String[] viewers = new String[viewerKeys.size()];
		viewerKeys.toArray(viewers);
		
		return viewers;		
	}
}
