/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AttachActionDelegate.java,v 1.11 2005/02/16 22:23:47 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Display;

/*
* CONTEXT_ID atha0000 for attach popup action
*/

public class AttachActionDelegate extends AbstractListenerActionDelegate {

	public void run(TRCAgentProxy fAgent, INavigator fViewer) {

		try {			
			TRCProcessProxy process = fAgent.getProcessProxy();
			String hostName = process.getNode().getName();
			Node node = PDCoreUtil.profileConnect(hostName, String.valueOf(process.getNode().getPort()));
			if (node == null) {
					return;
			}

			Object instance = LoadersUtils.locateAgentInstance(fAgent);
			if(instance != null && instance instanceof Agent)
			{
				Agent a = (Agent)instance;
				
				if (a.isActive())
				{
					if(fAgent.isActive())
					{
						PDCoreUtil.detachAgent(fAgent);
						fAgent.setActive(false);
					}
					
					TRCAgentProxy fAgentOld = fAgent;
					
					fAgent = PDCoreUtil.createUniqueAgent(process, a);
					
					PDCoreUtil.copyAgentProperties(fAgentOld,fAgent);
					
					PDCoreUtil.doAttach(a,fAgent);
					
					PDCoreUtil.activate(fAgent);

//					fAgent.setActive(true);
//					fAgent.setAttached(true);

//					AgentListener listener = (AgentListener)LoadersUtils.locateAgentListener(fAgent); 
//					if(listener != null && listener instanceof PIProcessListener)
//					{
//						((PIProcessListener)listener).monitor(true);
//					}
//					
//					
//					if (fAgent.isToProfileFile())
//					{
//						a.setProfileFile(fAgent.getProfileFile());					
//					}
//					else
//					{
//						a.setProfileFile(null);
//					}	
//					a.attach();
				}
			}

			ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
			event.setSource(fAgent);
			event.setType(ProfileEvent.ATTACH);
			UIPlugin.getDefault().notifyProfileEventListener(event);

			Display.getDefault().asyncExec(new Runnable() {
	        	public void run() {
	        		try{
	        			if (UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.PROFILE_TIPS)) {
		        			MessageDialogWithToggle.openInformation(UIPlugin.getActiveWorkbenchShell(), UIPlugin.getResourceString("PROFILING_TIP_TITLE"), UIPlugin.getResourceString("ATTACH_INFO_MESSAGE"), UIPlugin.getResourceString("ATTACH_MESSAGE_CHECKBOX_MSG"), false, UIPlugin.getDefault().getPreferenceStore(), TraceConstants.PROFILE_TIPS);
	        			}
	        		} catch (Exception exc) {
	        			exc.printStackTrace();
	        		}
	        	}
	        });

		}catch (Exception exc) {
			exc.printStackTrace();
		}

	}



	/**
	 * @see AbstractProfileActionDelegate#isEnabledFor(Object)
	 */
	protected boolean isEnabledFor(Object element) {

		if (element != null
			&& (element instanceof TRCAgentProxy)
			&& ((TRCAgentProxy) element).isActive()
			&& !((TRCAgentProxy) element).isAttached())
			return true;

		return false;

	}

	/**
	 * @see AbstractProfileActionDelegate#doAction(Object)
	 */
	public void doAction(Object object) throws Exception {

		if (object == null || !(object instanceof TRCAgentProxy))
			return;

		//INavigator fViewer = UIPlugin.getDefault().getViewer();
		INavigator fViewer = (INavigator)getView();
		if (fViewer == null) {
			MessageDialog.openInformation(
				UIPlugin.getActiveWorkbenchShell(),
				"title",
				"Action not available in current context");
			return;
		}

		run((TRCAgentProxy) object, fViewer);
	}
	
	public void dispose()
	{
		super.dispose();
	}
}
