/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ToggleLinkingAction.java,v 1.7 2005/02/16 22:23:47 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.util.ContextIds;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * This action toggles whether this navigator links its selection to the active
 * viewer.
 */
public class ToggleLinkingAction extends SelectionProviderAction
{
	INavigator navigator;
	
	/**
	 * Constructor for ToggleLinkingAction
	 * @param navigator
	 * @param label
	 */
	public ToggleLinkingAction(INavigator navigator, String label)
	{
		super(navigator.getViewer(), label);
		
		this.navigator = navigator;
		setChecked(navigator.isLinkingEnabled());
		WorkbenchHelp.setHelp(this, HyadesUIPlugin.getID() + ContextIds.ACT_TOGGLE_LINK);										
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		navigator.setLinkingEnabled(isChecked());
	}
	
	/**
	 * Disposes this action by removing it as a listener from the selection provider.
	 * This must be called by the creator of the action when the action is no longer needed.
	 */
	public void dispose() {
		super.dispose();
	}
	
}
