/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImportFilterUI.java,v 1.7 2005/04/18 17:51:35 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.internal.actions.CreateOrEditFilter;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterQueries;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ImportFilterUI implements SelectionListener, ModifyListener
{
	private Label  _filterLabel;
	private Button _editFilterButton;
	private Button _newFilterButton;
	private Combo  _filterListCombo;
	private String _scope;

	private FilterInformationManager _fi;
	//private String _selectedFilterName;
/**
 * TraceOptionsUI constructor comment.
 */
public ImportFilterUI(String scope) {
	//TODO get the type of filter to be listed
	super();
	_scope = scope;
	
	_fi = FilterInformationManager.instance(_scope);
}
/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 3:45:54 PM)
 * @param parent com.ibm.swt.widgets.Composite
 */
public Composite createControl(Composite parent)
{
	GridLayout layout;
	GridData   data;
	
	Composite result = new Composite(parent, SWT.NULL);
	layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=2;
	result.setLayout(layout);
	data = GridUtil.createHorizontalFill();
	result.setLayoutData(data);

	Label desc = new Label(result, SWT.WRAP);
	desc.setText(UIPlugin.getResourceString("FILTER_UI_DESC_LABEL"));
	
	Label space = new Label(result, SWT.NULL);
	
	_filterLabel = new Label(result, SWT.NULL);
	_filterLabel.setText(UIPlugin.getResourceString("SELECT_FILTER_LABEL"));

	_filterListCombo = new Combo(result, SWT.BORDER);
	_filterListCombo.setLayoutData(GridUtil.createHorizontalFill());
	_filterListCombo.addModifyListener(this);
	
	Composite buttonGroup = new Composite(result, SWT.NULL);
	layout = new GridLayout();
	layout.numColumns = 2;
	buttonGroup.setLayout(layout);
	buttonGroup.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));	
	
	_newFilterButton = new Button(buttonGroup, SWT.NULL);
	_newFilterButton.setText(UIPlugin.getResourceString("STR_NEW_FILTER_BUTTON"));

	_editFilterButton = new Button(buttonGroup, SWT.NULL);
	_editFilterButton.setText(UIPlugin.getResourceString("STR_EDIT_FILTER_BUTTON"));

	_newFilterButton.addSelectionListener(this);
	_editFilterButton.addSelectionListener(this);
	
	initialize();	
    	
	return result;
}

public void initialize(){
	//TODO collect the filter from the list
	_filterListCombo.removeAll();
	
	_filterListCombo.add(UIPlugin.getResourceString("NO_FILTER_LABEL"));

	Object[] filters = _fi.getFiltersArray();
	
	for (int i = 0; i < filters.length; i++)
	{
		_filterListCombo.add(((FilterQueries)filters[i]).name());
	}
	
	_filterListCombo.setFocus();
	
	setSelectedFilterName(_fi.selectedFilterName());
}

public void widgetDefaultSelected(SelectionEvent e) {}

public void widgetSelected(SelectionEvent e)
{
	if (_scope!=null)  {
		_fi = FilterInformationManager.instance(_scope);
		
		if(e.widget == _newFilterButton)
			CreateOrEditFilter.run(_fi, null);
		else if(e.widget == _editFilterButton)
			CreateOrEditFilter.run(_fi);
		
		initialize();
	}
}

public void modifyText(ModifyEvent e) {
	// TODO Auto-generated method stub
	if (e.widget == _filterListCombo)
	{
		if (_filterListCombo.getText().equals(UIPlugin.getResourceString("NO_FILTER_LABEL")))
		{
			_editFilterButton.setEnabled(false);
			_fi.selectedFilterName(null);
		}
		else
		{
			_editFilterButton.setEnabled(true);
			if (_fi.filter(_filterListCombo.getText().trim()) != null)
				_fi.selectedFilterName(_filterListCombo.getText().trim());	
		}
	}
}

public void setSelectedFilter(String selectedFilterName, String selectedFilterType)
{
	if (selectedFilterName != null)
	{
		FilterQueries fq = _fi.filter(selectedFilterName);
		if (fq != null && fq.type().equals(selectedFilterType))
			_fi.selectedFilterName(selectedFilterName);
		else
			_fi.selectedFilterName(null);
		
	}
	else
		_fi.selectedFilterName(null);
	
	setSelectedFilterName(_fi.selectedFilterName());	
}

public String getSelectedFilterName()
{
	return _fi.selectedFilterName();
}

public String getSelectedFilterType()
{
	return _fi.selectedFilter().type();
}

public SimpleSearchQuery getSelectedFilter()
{
	return _fi.getCurrentFilter();
}

private void setSelectedFilterName(String filterName)
{
	if (filterName != null)
		_filterListCombo.setText(filterName);
	else
		_filterListCombo.setText(UIPlugin.getResourceString("NO_FILTER_LABEL"));
}

}
