/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.filters;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.IFilterQueryProvider;
import org.eclipse.hyades.trace.ui.filters.IFilterViewer;
import org.eclipse.hyades.trace.ui.filters.internal.actions.FiltersSelectionAction;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.jface.action.IToolBarManager;


public abstract class FilterTraceViewer extends TraceViewer implements IFilterViewer {

	private FilterInformationManager _fi;
	private IFilterQueryProvider _fqp;
	private String _contentDescription = null;
	private boolean _internalCall = false;

	public void makeActions()
	{
		if (isInitializedMenu())
			return; //create the toolbar only once

		initializedMenu(true);
		
		IToolBarManager tbm = getViewSite().getActionBars().getToolBarManager();
		tbm.removeAll();
		
		_fi = FilterInformationManager.instance(this);
		tbm.add(new FiltersSelectionAction(_fi));
		
		// require update because toolbar control has been created by this point,
		// but manager does not update it automatically once it has been created
		//getViewSite().getActionBars().updateActionBars();		
	}
	
	public void dispose() {
		if (_fqp != null)
			_fqp.viewerDisposed();
		
		_fqp = null;
		
		super.dispose();
	}
	
	public void setFilterQueryProvider(IFilterQueryProvider filterQueryProvider)
	{
		_fqp = filterQueryProvider;
	}
	
	public SimpleSearchQuery getCurrentFilter()
	{
		return _fqp.getCurrentFilter();
	}

	public SimpleSearchQuery standardQuery()
	{
		return _fqp.standardQuery();
	}	
	
	public SimpleSearchQuery advancedQuery()
	{
		return _fqp.advancedQuery();
	}
	
	public void updateAdvancedQuery(SimpleSearchQuery query, int advancedTabSelectionIndex)
	{
		_fqp.updateAdvancedQuery(query, advancedTabSelectionIndex);	
	}
	

	public void updateFilterAppliedDescription() {
		String filterAppliedName;
		
		if (_fqp != null && _fqp.getCurrentFilter() != null)
			filterAppliedName = _fqp.getCurrentFilter().getName();
		else
			filterAppliedName = UIPlugin.getResourceString("STR_ST_FILTER_NAME_APPLIED_NO_FILTER");
		
		if (_contentDescription == null)
			_contentDescription = "";
		
		String filterStr = TString.change(UIPlugin.getResourceString("STR_ST_FILTER_NAME_APPLIED_PREFIX"), "%1", filterAppliedName);
		
		_internalCall = true;
		setContentDescription(_contentDescription + "  (" + filterStr + " )");
		_internalCall = false;
	}
	
	protected void setContentDescription(String description) {
		if (_internalCall)
			super.setContentDescription(description);
		else
		{
			_contentDescription = description;
			updateFilterAppliedDescription();
		}
	}
}
