/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.filters;

import org.eclipse.hyades.trace.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.trace.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * 
 * An interface representing a Filter Type definition.
 */
public interface IFilterType {
	/**
	 * The filter type ID.
	 */	
	public String id();
	
	/**
	 * The associated filter type name, displayable in the UI.
	 */	
	public String name();
	
	/**
	 * The associated filter type icon, displayable in the UI.
	 */		
	public ImageDescriptor icon();
	
	/**
	 * The associated filter type description.
	 */			
	public String description();
	
	/**
	 * The associated filter type FiltersStandardTabUI definition.
	 */	
	public FiltersStandardTabUI standardTabUI();
	
	/**
	 * The associated filter type FiltersStandardTabUI definition.
	 */	
	public IAdvancedTabAttributeSet advancedTabAttributeSet();
	
	/**
	 * The type descriptions this filter type is associated with, its
	 * type descriptions scope.
	 */	
	public String[] scope();
}
