/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileAgentsTab.java,v 1.15 2005/04/19 23:24:25 ewchan Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.DoubleCTree;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.help.WorkbenchHelp;

public class ProfileAgentsTab extends AbstractLaunchConfigurationTab {
	private ILaunchConfiguration _conf;

	private DoubleCTree _list;

	private boolean _initialized = false;

	public void createControl(Composite parent) {
		_initialized = false;

		Composite content = new Composite(parent, SWT.NULL);
		setControl(content);
		content.setLayout(new GridLayout());
		createVerticalSpacer(content, 1);

		_list = new DoubleCTree(content, SWT.NULL, UIPlugin
				.getResourceString("STR_LIST_AGENTS"), UIPlugin
				.getResourceString("STR_LIST_SOURCE"), UIPlugin
				.getResourceString("STR_LIST_TARGET"));
		_list.addListener(new Listener() {
			public void handleEvent(Event event) {
				// the list changed; update
				updateLaunchConfigurationDialog();
			}
		});

		Button refresh = new Button(content, SWT.PUSH);
		refresh.setText(UIPlugin.getResourceString("RESET_DATA"));
		refresh.setToolTipText(UIPlugin
				.getResourceString("REINITIALIZE_AGNT_TOOLTIP"));
		refresh.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				_list.initialize();
			}
		});

		WorkbenchHelp.setHelp(_list.getControl(), UIPlugin.getPluginId()
				+ ".atlp0002");
		WorkbenchHelp.setHelp(refresh, UIPlugin.getPluginId() + ".atlp0000");
		WorkbenchHelp.setHelp(parent, UIPlugin.getPluginId() + ".atlp0002");

	}
	
	public boolean isValid(ILaunchConfiguration conf) {
		setErrorMessage(null);
		setMessage(null);

		if (conf != null && !_list.treesLoaded())
		{
			setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_AGENTS"));
			return false;
		}		
		
		if (_list.getSelectedItemsForProfiling().length == 0) {
			setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_AGENTS"));
			return false;
		}

		return true;
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
	}

	public void initializeFrom(ILaunchConfiguration conf) {
		if (_conf != conf)
		{
			_initialized = false;
			_list.treesLoaded(false);
		}

		_conf = conf;

		_list.initializeLaunchConfiguration(_conf);

		boolean storedLaunchConfiguration = _list.getAttributeAgents().size() > 0;
		
		if ((getControl().isVisible() && !_initialized)
				||
			(!_initialized && storedLaunchConfiguration)
			) {
			_list.initialize();
			_initialized = true;
		}

	}

	public void performApply(ILaunchConfigurationWorkingCopy wc) {
		if (_initialized && _list.treesLoaded())
		{
 			List list = DoubleCTree.getAttributeAgents(_list.getSelectedItemsForProfiling());	
 			List attrStringsList = new ArrayList();
 			for (int i = 0; i < list.size(); i++)
 				attrStringsList.add(((AgentAttribute)list.get(i)).getAttributeString());
	
			wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, attrStringsList);
		}
	}

	public String getName() {
		return UIPlugin.getResourceString("TAB_NAME_AGENTS");
	}

	public Image getImage() {
		return PDPluginImages.getImage(PDPluginImages.IMG_UI_AGENT);
	}

	void reset() {
		_initialized = false;
		_list.removeAll();
	}
}