/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfilingSet.java,v 1.3 2005/02/16 22:24:01 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.*;
import java.util.Map;

import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;

public class ProfilingSet implements IProfilingSet{
	
	protected String id;
	protected String name;
	protected String description;
	protected List profilingTypes = new ArrayList();
	protected Map attributes = new HashMap();
	
	/**
	 * @return Returns the id.
	 */
	public String getId() {
		return id;
	}
	/**
	 * @param id The id to set.
	 */
	public void setId(String id) {
		this.id = id;
	}
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return Returns the attributes.
	 */
	public Map getAttributes() {
		return attributes;
	}
	/**
	 * @param attributes The attributes to set.
	 */
	public void setAttributes(Map attributes) {
		this.attributes = attributes;
	}
	/**
	 * @return Returns the profilingTypes.
	 */
	public List getProfilingTypes() {
		return profilingTypes;
	}
	/**
	 * @param profilingTypes The profilingTypes to set.
	 */
	public void setProfilingTypes(List profilingTypes) {
		this.profilingTypes = profilingTypes;
	}
	/**
	 * @return Returns the description.
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * @param description The description to set.
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * @param id
	 * @param name
	 * @param description
	 */
	public ProfilingSet(String id, String name, String description) {
		super();
		this.id = id;
		this.name = name;
		this.description = description;
	}
}
