/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfilingSetType.java,v 1.3 2005/02/16 22:24:01 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.hyades.trace.ui.launcher.*;
import org.eclipse.jface.resource.ImageDescriptor;

public class ProfilingSetType implements IProfilingSetType{
	
	protected String id;
	protected String name;
	protected String description;
	protected ImageDescriptor image;
	protected boolean useFilters;
	protected String group;	
	protected IProfilingType profilingType;
	
	/**
	 * @return Returns the id.
	 */
	public String getId() {
		return id;
	}
	/**
	 * @param id The id to set.
	 */
	public void setId(String id) {
		this.id = id;
	}
	/**
	 * @return Returns the image.
	 */
	public ImageDescriptor getImage() {
		return image;
	}
	/**
	 * @param image The image to set.
	 */
	public void setImage(ImageDescriptor image) {
		this.image = image;
	}
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return Returns the profilingType.
	 */
	public IProfilingType getProfilingType() {
		return profilingType;
	}
	/**
	 * @param profilingType The profilingType to set.
	 */
	public void setProfilingType(IProfilingType profilingType) {
		this.profilingType = profilingType;
	}
	/**
	 * @return Returns the useFilters.
	 */
	public boolean isUseFilters() {
		return useFilters;
	}
	/**
	 * @param useFilters The useFilters to set.
	 */
	public void setUseFilters(boolean useFilters) {
		this.useFilters = useFilters;
	}
	/**
	 * @param id
	 * @param name
	 * @param description
	 * @param image
	 * @param useFilters
	 * @param group
	 * @param profilingType
	 */
	public ProfilingSetType(String id, String name, String description,
			ImageDescriptor image, boolean useFilters, String group,
			IProfilingType profilingType) {
		super();
		this.id = id;
		this.name = name;
		this.description = description;
		this.image = image;
		this.useFilters = useFilters;
		this.group = group;
		this.profilingType = profilingType;
	}
	/**
	 * @return Returns the description.
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * @param description The description to set.
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * @return Returns the group.
	 */
	public String getGroup() {
		return group;
	}
	/**
	 * @param group The group to set.
	 */
	public void setGroup(String group) {
		this.group = group;
	}
}
