/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MethodCodeCoverageUI.java,v 1.7 2005/02/16 22:24:01 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher.defaults;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class MethodCodeCoverageUI {
	
	private String options;
	
	private Label titleLabel;
	private Label optionsLabel;
	
	public MethodCodeCoverageUI() {
		super();
	}

	public Composite createControl(Composite parent) {
		
		GridLayout layout;

		Composite result = new Composite(parent, SWT.NONE);

		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 2;

		GridData data = GridUtil.createFill();
		result.setLayout(layout);
		result.setLayoutData(data);
		
		titleLabel = new Label(result, SWT.NULL);
		titleLabel.setText(UIPlugin.getResourceString("coverageType"));
		titleLabel.setLayoutData(GridUtil.createHorizontalFill());
		//white
		titleLabel.setBackground(new Color(null, 255, 255, 255));
		Font font = titleLabel.getFont();
		if (font != null) {
			FontData[] fonts = font.getFontData();
			if (fonts != null && fonts.length >= 1) {
				titleLabel.setFont(new Font(Display.getDefault(), fonts[0].getName(), fonts[0].getHeight() + 3, SWT.BOLD));
			}
		}
		
		new Label(result, SWT.NULL);
		
		optionsLabel = new Label(result, SWT.WRAP);
		optionsLabel.setText(UIPlugin.getResourceString("STR_ANALYZE_COVERAGE"));
		data = new GridData();
		data.horizontalIndent = 20;
		data.widthHint = 375;
		optionsLabel.setLayoutData(data);
		return result;
	}
}
