/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MonitorLabelProvider.java,v 1.4 2005/02/16 22:24:01 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class MonitorLabelProvider extends LabelProvider
{
  private Image fMonitor =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_MONITOR);


  private Image fDetachedAgent =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_DETACHED_AGENT); 

/**
 * Returns the image to display for the passed resource element.
 * NOTE: The resource label provider caches its images, so don't
 * dispose them!
 */
public Image getImage(Object element)
{
	if (element instanceof IFile)
	{
	  return fMonitor;		
	}	
	else if (element instanceof IAdaptable)
	{
		IWorkbenchAdapter adapter =
			(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

		return adapter == null ? null : adapter.getImageDescriptor(element).createImage();

	}
	else if(element instanceof TRCMonitor)
	  return fMonitor;

	return(null);
}
/* (non-Javadoc)
 * Method declared on ILabelProvider.
 */
public String getText(Object element)
{
	if (element instanceof IFile)
	{
		IFile file = (IFile)element;
		
		return file.getName().substring(0, file.getName().length()-file.getFileExtension().length()-1);
	}	
	else if (element instanceof IAdaptable)
	{
		IWorkbenchAdapter adapter =
			(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

		return adapter == null ? "?" : adapter.getLabel(element);
	}
	else if(element instanceof TRCMonitor)
	  return ((TRCMonitor)element).getName();
	  
	return "";
}
}
