/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProcessTreeItem.java,v 1.7 2005/04/19 23:24:25 ewchan Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.graphics.Image;

public class ProcessTreeItem implements IAdaptable {
	private Object _adapter;
	private Object _data;
	private ProcessTreeItem _parent;
	private ProcessTreeItem[] _children;

	public ProcessTreeItem(Object data, ProcessTreeItem parent) {
		_data = data;
		_parent = parent;
		_children = null;
	}

	public Object getData() {
		return _data;
	}
	
	public ProcessTreeItem getParent()
	{
		return _parent;
	}
	
	public void setChildren(ProcessTreeItem[] children)
	{
		_children = children;
	}	
	
	public ProcessTreeItem[] getChildren()
	{
		return _children;
	}	

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter) {
		return _adapter;
	}

	public void setAdapter(Object adapter) {
		_adapter = adapter;
	}

	public String getLabelText() {
		if (_data == null)
			return "";
		else if (_data instanceof Process) {
			String label = ((Process) _data).getName();
			if (label == null) {
				label = ((Process) _data).getExecutable();
			}
			String text = UIPlugin.getResourceString("STR_PROCESS_LABEL_SHORT");
			text = TString.change(text, "%1", label);

			try {
				text = TString.change(text, "%2", String.valueOf(((Process) _data).getProcessId()));
			} catch (InactiveProcessException exc) {
				return label;
			}
			return text;
		} else if (_data instanceof Agent) {
			return ((Agent) _data).getName();
		} else if (_data instanceof ErrorItem) {
			return ((ErrorItem) _data).getMessage();
		}

		return "";
	}

	public Image getImage() {
		if (_data == null)
			return null;
		else if (_data instanceof Process) {
			return PDPluginImages.getImage(PDPluginImages.IMG_UI_PROCESS);
		} else if (_data instanceof Agent) {
			return PDPluginImages.getImage(PDPluginImages.IMG_UI_DETACHED_AGENT);
		} else if (_data instanceof ErrorItem) {
			return PDPluginImages.getImage(PDPluginImages.IMG_ERROR_ITEM);
		}

		return null;
	}
	
	public String getProcessId()
	{
		Process process = null;
		
		if (_data instanceof Process)
			process = (Process)_data;
		else if (_data instanceof Agent)
			process = (Process)getParent().getData();
		
		if (process != null)
		{
			try
			{	
				return process.getProcessId();
			}
			catch (InactiveProcessException exc)
			{			
			}
		}
		
		return null;
	}

}
