/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id:
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;


public class ExportFilterWizard extends Wizard implements IImportWizard
{
	private IWorkbench workbench;
	private IStructuredSelection selection;
	private ExportFilterWizardPage mainPage;
	private boolean success = true;

public ExportFilterWizard() {
	AbstractUIPlugin plugin = UIPlugin.getDefault();
	IDialogSettings workbenchSettings = plugin.getDialogSettings();
	IDialogSettings section = workbenchSettings.getSection("FilterFileExportWizard");//$NON-NLS-1$
	if(section == null)
		section = workbenchSettings.addNewSection("FilterFileExportWizard");//$NON-NLS-1$
	setDialogSettings(section);
}

public void addPages()
{
  	setWindowTitle(UIPlugin.getResourceString("EXPORT_XML_FILTER_TITLE"));	
  		
	super.addPages();
	mainPage = new ExportFilterWizardPage(workbench,selection);
	addPage(mainPage);
}

public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
	this.workbench = workbench;
	selection = currentSelection;
	setDefaultPageImageDescriptor(PDPluginImages.getImageDescriptor(PDPluginImages.IMG_UI_WZ_EXPORT_FILTER));
	setNeedsProgressMonitor(true);
}

public boolean performFinish()
{
	return mainPage.finish();
}
}
