/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.trace.ui.internal.filters.ModelUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;


public class FiltersStandardTabTraceViewsUI extends FiltersStandardTabUI {
	public static EAttribute ATTRIBUTE_PACKAGE_NAME = TracePackageImpl.init().getTRCPackage_Name();
	public static EAttribute ATTRIBUTE_CLASS_NAME = TracePackageImpl.init().getTRCClass_Name();
	public static EAttribute ATTRIBUTE_METHOD_NAME = TracePackageImpl.init().getTRCMethod_Name();
	
	public static RelationalOperators OPERATOR_LIKE = RelationalOperators.get(RelationalOperators.LIKE);
	
	private boolean _showMethodLevel;
	
	private Text _filterText;
	private Button _packageLevel;
	private Button _classLevel;
	private Button _methodLevel;
	private Button _caseControl;	
	
	//private ImportTraceRange _traceRange;	
	//private FilterEventsUI _eventsUI;
	
	public FiltersStandardTabTraceViewsUI(boolean showMethodLevel)
	{
		super();
		_showMethodLevel = showMethodLevel;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.filters.ui.IFiltersTabUI#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public Control createControl(Composite parent) {
		Composite content = new Composite(parent, SWT.NULL);
		content.setLayout(new GridLayout());
		
		Composite filterContainer = new Composite(content, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		filterContainer.setLayout(layout);
		GridData data = GridUtil.createHorizontalFill();
		//data.horizontalSpan = 2;
		filterContainer.setLayoutData(data);

		
		Label filter = new Label(filterContainer, SWT.NULL);
		filter.setText(UIPlugin.getResourceString("STR_ST_FILTER"));
		
		
		Composite filterTextContainer = new Composite(filterContainer, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 2;
		filterTextContainer.setLayout(layout);
		data = GridUtil.createHorizontalFill();
		//data.horizontalSpan = 2;
		filterTextContainer.setLayoutData(data);

		_filterText = new Text(filterTextContainer, SWT.BORDER);
		_filterText.setLayoutData(GridUtil.createHorizontalFill());
		_filterText.addKeyListener(new KeyAdapter() {
			public void keyReleased(KeyEvent key) {
				//saveFilterText(filterText.getText());
			}
		});

		_caseControl = new Button(filterTextContainer, SWT.CHECK);
//		//_caseControl.setLayoutData(GridUtil.createHorizontalFill());
		_caseControl.setLayoutData(new GridData());
		_caseControl.setText(UIPlugin.getResourceString("STR_ST_CASE_SENSITIVE"));
//		_caseControl.setSelection(true);		
//		caseControl.addSelectionListener(new SelectionAdapter() {
//			public void widgetSelected(SelectionEvent e) {
//				//putAttributeOperatorValue(ATTRIBUTE_CASE_CONTROL, OPERATOR_LIKE, String.valueOf(caseControl.getSelection()));
//			}
//		});
//
		
//		Composite levelContainer1 = new Composite(filterContainer, SWT.NULL);
//		layout = new GridLayout();
//		layout.numColumns = 2;
//		levelContainer1.setLayout(layout);
//		levelContainer1.setLayoutData(GridUtil.createHorizontalFill());
//		Label blankLabel = new Label(levelContainer1, SWT.NULL);		
		
		
		Composite levelContainer = new Composite(filterContainer, SWT.NULL);
		layout = new GridLayout();
		levelContainer.setLayout(layout);
		levelContainer.setLayoutData(GridUtil.createHorizontalFill());
		
		Label filterByLabel = new Label(levelContainer, SWT.NULL);
		filterByLabel.setText(UIPlugin.getResourceString("STR_ST_FILTER_BY"));

		Composite buttonLevelContainer = new Composite(levelContainer, SWT.NULL);
		layout = new GridLayout();
		buttonLevelContainer.setLayout(layout);
		buttonLevelContainer.setLayoutData(GridUtil.createHorizontalFill());
		
		_packageLevel = new Button(buttonLevelContainer, SWT.RADIO);
		_packageLevel.setText(UIPlugin.getResourceString("STR_ST_FILTER_PACKAGE_LEVEL"));
		_packageLevel.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//changeLevelTo(ATTRIBUTE_PACKAGE_NAME);
			}
		});
		
		_classLevel = new Button(buttonLevelContainer, SWT.RADIO);
		_classLevel.setText(UIPlugin.getResourceString("STR_ST_FILTER_CLASS_LEVEL"));
		_classLevel.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//changeLevelTo(ATTRIBUTE_CLASS_NAME);
			}
		});
		
		_methodLevel = null;
		if (_showMethodLevel)
		{
			_methodLevel = new Button(buttonLevelContainer, SWT.RADIO);
			_methodLevel.setText(UIPlugin.getResourceString("STR_ST_FILTER_METHOD_LEVEL"));
			_methodLevel.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					//changeLevelTo(ATTRIBUTE_METHOD_NAME);
				}
			});
		}
		
//		_traceRange = new ImportTraceRange(this);
//		_traceRange.createControl(content);
		
		createSpacer(content);
		
		return content;
	}

	protected void createSpacer(Composite parent) {
		Label spacer = new Label(parent, SWT.NONE);
		GridData data = new GridData();
		data.horizontalAlignment = GridData.FILL;
		data.verticalAlignment = GridData.BEGINNING;
		spacer.setLayoutData(data);
	}	

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.filters.ui.internal.dialog.FiltersTabUI#initializeFrom(org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery)
	 */
	public void initializeFrom(SimpleSearchQuery filter) {
		// initialize values		
		_filterText.setText("");
		_caseControl.setSelection(true);
		//_eventsUI.initializeValues();
		boolean levelSet = false;
		
		if (filter.getWhereExpression() != null 
				&& (filter.getWhereExpression() instanceof LogicalExpression))
		{
			 LogicalExpression logicalExpression = (LogicalExpression)filter.getWhereExpression();
			 EList filterElements = logicalExpression.getArguments();

			 for (int i = 0; i < filterElements.size(); i++)
			 {
				BinaryExpression be = (BinaryExpression)filterElements.get(i);
				EStructuralFeature feature = ((SimpleOperand)be.getLeftOperand()).getFeature();
				//EClass type = be.getLeftOperand().getType();				

				if (feature != null)
				{
					boolean validFeature = false;
					if (feature.equals(ATTRIBUTE_PACKAGE_NAME))
					{
						_packageLevel.setSelection(true);
						validFeature = true;
					}
					else if (feature.equals(ATTRIBUTE_CLASS_NAME))
					{
						_classLevel.setSelection(true);
						validFeature = true;
					}						
					else if (feature.equals(ATTRIBUTE_METHOD_NAME))
					{
						_methodLevel.setSelection(true);
						validFeature = true;
					}						

					if (validFeature)
					{
						_filterText.setText(String.valueOf(((SimpleOperand)be.getRightOperands().get(0)).getRawValue()));
						_caseControl.setSelection(!be.isCaseInsensitive());
						levelSet = true;
					}
				}
			}
		}
		
		if (!levelSet)
			_packageLevel.setSelection(true);

		//_eventsUI.initializeFrom(filter);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.filters.ui.internal.dialog.FiltersTabUI#performApply(org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery)
	 */
	public SimpleSearchQuery performApply() {
		SimpleSearchQuery filter = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();		
		LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
		logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
		EList arguments = logicalExpression.getArguments();
		
		//_eventsUI.performApply(filter);
		
		if (_filterText.getText().trim().length() > 0)
		{
			if (_packageLevel.getSelection())
				arguments.add(ModelUtils.createBinaryExpression(ATTRIBUTE_PACKAGE_NAME, OPERATOR_LIKE, _filterText.getText().trim(), !_caseControl.getSelection()));
			else if (_classLevel.getSelection())
				arguments.add(ModelUtils.createBinaryExpression(ATTRIBUTE_CLASS_NAME, OPERATOR_LIKE, _filterText.getText().trim(), !_caseControl.getSelection()));			
			else if (_methodLevel != null && _methodLevel.getSelection())
				arguments.add(ModelUtils.createBinaryExpression(ATTRIBUTE_METHOD_NAME, OPERATOR_LIKE, _filterText.getText().trim(), !_caseControl.getSelection()));
		}
		
		filter.setWhereExpression(logicalExpression);
		
		return filter;
	}

}
