/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id:
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterResourceFileHandler;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterResourceHandler;
import org.eclipse.hyades.trace.ui.internal.filters.FilterTypesManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;

public class ImportFilterWizardPage extends ExportImportFilterWizardPage
{
    //~ Constructors -------------------------------------------------------------------------------

    /**
     *  Creates an instance of this class
     * @param aWorkbench IWorkbench
     * @param selection IStructuredSelection
     */
    public ImportFilterWizardPage(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("FilterImportPage", aWorkbench, selection); //$NON-NLS-1$
        setTitle(UIPlugin.getResourceString("IMPORT_FILTER_PAGE_TITLE")); //$NON-NLS-1$
        setDescription(UIPlugin.getResourceString("IMPORT_FILTER_PAGE_DESC")); //$NON-NLS-1$
        setImageDescriptor(PDPluginImages.getImageDescriptor(PDPluginImages.IMG_UI_WZ_IMPORT_FILTER));
    }

    //~ Methods ------------------------------------------------------------------------------------

    /** (non-Javadoc)
     * Method declared on IDialogPage.
     */
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, SWT.NULL);

        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL));
        composite.setSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));

        createSourceGroup(composite);

        createSpacer(composite);
        
        createBoldLabel(composite, UIPlugin.getResourceString("STR_SELECT_FILTER_IMPORT_LABEL")); //$NON-NLS-1$
		
        createDoubleList(composite, UIPlugin.getResourceString("IMPORT_AVAILABLE_FILTERS"),UIPlugin.getResourceString("IMPORT_SELECTED_FILTERS")); //$NON-NLS-1$ //$NON-NLS-2$
        
        setControl(composite);
    }
	
	protected List populateFilterList() {
		String filterFile = sourceNameField.getText().trim();
		List list = new ArrayList();

		if ((new File(filterFile)).exists())
		{
	    	FilterResourceFileHandler resource = FilterResourceFileHandler.instance(URI.createFileURI(filterFile));
	    	
			Object[] filterQueries = resource.toArray();
			
			for (int i = 0; i < filterQueries.length; i++)
			{
				if (FilterTypesManager.instance().getFilterType(((FilterQueries)filterQueries[i]).type()) != null)
					list.add(((FilterQueries)filterQueries[i]).copy());
			}
			
			resource.unload();
		}
		return list;    	
	}
	
    /**
     * The Finish button was pressed.  Try to do the required work now and answer
     * a boolean indicating success.  If <code>false</code> is returned then the
     * wizard will not close.
     *
     * @return boolean
     */
    public boolean finish() {
    	List filtersToImport = getDoubleList().getTargetItems();
    	
    	FilterResourceHandler importResourceHandler = FilterResourceHandler.instance();
    	
    	for (int i = 0; i < filtersToImport.size(); i++)
    	{
    		importResourceHandler.addFilter(((FilterQueries)filtersToImport.get(i)).copy());
    	}
    	
    	importResourceHandler.save();

    	return true;
    }

	protected boolean validateLists() {
    	List filtersToImport = getDoubleList().getTargetItems();
    	
    	for (int i = 0; i < filtersToImport.size(); i++)
    	{
    		FilterQueries fq = (FilterQueries)filtersToImport.get(i);
    		if (FilterResourceHandler.instance().filter(fq.name()) != null)
    		{
    			setErrorMessage(TString.change(UIPlugin.getResourceString("STR_IMPORT_FILTER_DUPLICATE_FILTER_NAME"), "%1", fq.name()));
    			return false;
    		}
    	}
        
        return true;
	}
	
    /**
     * Sent when the text is modified.
     *
     * @param e an event containing information about the modify
     */
    public void modifyText(ModifyEvent e) {
    	super.modifyText(e);
        initializeValues();
    }
}
