/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NewMonitorWizardPage.java,v 1.4 2005/02/16 22:24:02 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.File;
import java.util.ArrayList;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/*
* CONTEXT_ID nmwp0000 for in new monitor wizard page
*/

public class NewMonitorWizardPage  extends WizardPage
				   implements ModifyListener
{
	protected IResource fSelection;
	protected TraceLocationUI _locationUI;
	private TRCMonitor fMonitor;

  public NewMonitorWizardPage(String name, IResource selection)
  {
	super(name);
	setTitle(UIPlugin.getResourceString("CREATE_MONITOR_TITLE"));
	setDescription(UIPlugin.getResourceString("CREATE_MONITOR_DESC"));

	fSelection = selection;
  }  
  public void createControl(Composite parent)
  {
	Label label;

	Composite content = new Composite(parent, SWT.NONE);
	GridLayout layout = new GridLayout();
	layout.numColumns = 1;
	content.setLayout(layout);
	GridData gd = GridUtil.createFill();	
	content.setLayoutData(gd);

	_locationUI = new TraceLocationUI();
	_locationUI.createControl(content);
	_locationUI.setEnabledBrowse(false);
	_locationUI.setEnabledLocation(false);

//  top level group
	Composite group = new Composite(content, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 2;
	layout.verticalSpacing=0;           
	group.setLayout(layout);
	group.setLayoutData(GridUtil.createFill());
	
	//add listeners
	_locationUI.getLocation().addModifyListener(this);
	_locationUI.getMonitor().addModifyListener(this);        
	
	_locationUI.getMonitor().setFocus();

	setControl(content);

	_locationUI.setMonitor("");
	if(fSelection != null)
	   _locationUI.setLocation(fSelection.getFullPath().toOSString());  

	setPageComplete(false);

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
	parent,
	UIPlugin.getPluginId()+".nmwp0000");
	
  }  
  public boolean finish()
  {
	String name = _locationUI.getMonitor().getText().trim();
	String location = _locationUI.getLocation().getText().trim();

	PDProjectExplorer viewer = ((NewMonitorWizard)getWizard()).getViewer();
	
	IContainer container = PDCoreUtil.createContainer(new Path(location));							
	PDCoreUtil.createMonitor(container, name);
	
	return(true);
	
  }  
public TRCMonitor getMonitor() {
	return fMonitor;
}/**
 * Insert the method's description here.
 * Creation date: (11/30/2000 3:11:28 PM)
 * @return com.ibm.etools.perftrace.TRCMonitor
 */ 
	/**
 * Insert the method's description here.
 * Creation date: (08/21/2000 7:51:52 PM)
 * @param event com.ibm.swt.events.ModifyEvent
 */
public void modifyText(ModifyEvent event)
{
	String containerName = _locationUI.getLocation().getText().trim();
	String fileName = _locationUI.getMonitor().getText().trim();
	
	if(containerName.equals("") || containerName.equals(""))
	{
		setErrorMessage(null);          		
		setPageComplete(false);
		return;
	}

	if(event.widget == _locationUI.getMonitor())
	{
		setErrorMessage(null);          

		IWorkspace workbench = UIPlugin.getPluginWorkbench();

		Path path = new Path(containerName);
		IContainer container = null;
		
		IResource res = workbench.getRoot().findMember(path);
		if(res == null || !res.exists())   
		{
			setPageComplete(true);
			return;                             
		}

		if(!(res instanceof IContainer))
	    {
			String msg = UIPlugin.getResourceString("CONTAINER_INVALID");
			msg = TString.change(msg, "%1", containerName);
			setErrorMessage(msg);               
		    
			setPageComplete(false);
			return;                             
		    
	    }
		
		container = (IContainer) res; 
		res = container.findMember(fileName+File.separator+TraceConstants.MONITOR_EXT);
		if(res != null)
		{
			String msg = UIPlugin.getResourceString("FILE_ALD_EXIST");
			msg = TString.change(msg, "%1", containerName);
			msg = TString.change(msg, "%2", File.separator);
			msg = TString.change(msg, "%3", fileName);
			msg = TString.change(msg, "%4", TraceConstants.MONITOR_EXT);
			setErrorMessage(msg);                                   
			setPageComplete(false);
			return;                     			
		}
			
		ArrayList monitors = PDContentProvider.getMonitors(container);
		for(int idx=0; idx<monitors.size(); idx++)
		{
			TRCMonitor monitor = (TRCMonitor)monitors.get(idx);
			if(monitor != null && monitor.getName().equals(fileName))
			{
				String msg = UIPlugin.getResourceString("FILE_ALD_EXIST");
				msg = TString.change(msg, "%1", containerName);
				msg = TString.change(msg, "%2", File.separator);
				msg = TString.change(msg, "%3", fileName);
				msg = TString.change(msg, "%4", TraceConstants.MONITOR_EXT);
				setErrorMessage(msg);                                   
				setPageComplete(false);
				return;                     
			}
		}

		setPageComplete(true);
	}
}
}
