/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenNodeWizard.java,v 1.4 2005/02/16 22:24:02 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.*;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;

public class OpenNodeWizard extends NewNodeWizard
{
	protected TRCNode fNode;

  public OpenNodeWizard()
  {
	  super();
  }  
  public void addPages()
  {
  	setWindowTitle(UIPlugin.getResourceString("STR_PROPERTIES"));	
	fPage = new OpenNodeWizardPage("com.ibm.etools.pd.core.wizard.OpenNodePage");
	addPage(fPage);
  }    
/**
 * Insert the method's description here.
 * Creation date: (10/05/2000 3:48:43 PM)
 * @return com.ibm.etools.perftrace.TRCNode
 */
public TRCNode getNode() {
	return fNode;
}
  public void init(IWorkbench workbench, IStructuredSelection selection)
  {
	if (selection instanceof IStructuredSelection)
	{
	  Iterator enum = ((IStructuredSelection) selection).iterator();
	  if (enum.hasNext())
	  {
		Object obj = enum.next();
		if (obj instanceof TRCNode)
		  fNode = (TRCNode) obj;
	  }
	}
	
	setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_NODE_PROP));
  }  
  public boolean performFinish()
  {
	if(fPage.finish())
	{
		fNode.setPort(Integer.parseInt(fPage._nodeUI.getPortNumberUI().getText().trim()));
		fViewer.getViewer().refresh(fNode.getMonitor());   
		return true;	
	}

	return false;

  }  
}
