/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenProcessWizard.java,v 1.4 2005/02/16 22:24:02 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.*;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;

public class OpenProcessWizard extends Wizard implements INewWizard
{
  protected PDProjectExplorer fViewer;
  protected IStructuredSelection fSelection;
  protected TRCProcessProxy fProcess;
  protected OpenProcessWizardPage fPage;

  public OpenProcessWizard()
  {
	setNeedsProgressMonitor(true);
  }  
  public void addPages()
  {
  	setWindowTitle(UIPlugin.getResourceString("STR_PROPERTIES"));	
	fPage = new OpenProcessWizardPage("com.ibm.etools.pd.core.wizard.OpenProcessPage");
	addPage(fPage);
  }    
/**
 * Insert the method's description here.
 * Creation date: (5/3/2001 10:39:01 AM)
 * @return com.ibm.etools.perftrace.TRCProcessProxy
 */
public TRCProcessProxy getProcess() {
	return fProcess;
}
/**
 * Insert the method's description here.
 * Creation date: (5/3/2001 10:38:29 AM)
 * @return com.ibm.etools.pd.core.PDProjectExplorer
 */
public PDProjectExplorer getViewer() {
	return fViewer;
}
  public void init(IWorkbench workbench, IStructuredSelection selection)
  {
	fSelection = selection;
	if (selection instanceof IStructuredSelection)
	{
	  Iterator enum = ((IStructuredSelection) selection).iterator();
	  if (enum.hasNext())
	  {
		Object cg = enum.next();
		if (cg instanceof TRCProcessProxy)
		{		
		  fProcess = (TRCProcessProxy) cg;
		}
	  }
	}

	setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_PROC_PROP));	
  }  
  public boolean performFinish()
  {
	return fPage.finish();
  }  
  public void setViewer(PDProjectExplorer viewer)
  {
	fViewer = viewer;
  }  
}
