/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenProfAgentFolderPage.java,v 1.6 2005/02/16 22:24:02 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.File;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceFileUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;


/*
 * CONTEXT_ID opaf0000 for open profile agnet folder page
 */
public class OpenProfAgentFolderPage extends WizardPage implements ModifyListener, SelectionListener {
    //~ Instance fields ----------------------------------------------------------------------------

    protected PDProjectExplorer fViewer;
    private String location;
    private String monitor;
    private TraceFileUI _fileUI;
    private TraceLocationUI _locationUI;

    //~ Constructors -------------------------------------------------------------------------------

    public OpenProfAgentFolderPage(String name, PDProjectExplorer viewer) {
        super(name);
        setTitle(UIPlugin.getResourceString("STR_DEST_MON_PAGE"));
        setDescription(UIPlugin.getResourceString("STR_DEST_MON_DESC"));
        fViewer = viewer;
    }

    //~ Methods ------------------------------------------------------------------------------------

    public String getFile() {
        return (_fileUI.getSelection() ? _fileUI.getFile() : "");
    }

    public String getMonitor() {
        return monitor;
    }

    public String getProject() {
        return location;
    }

    public void createControl(Composite parent) {
        GridLayout layout;

        Composite btnGroup = new Composite(parent, SWT.NULL);

        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        btnGroup.setLayout(layout);
        btnGroup.setLayoutData(GridUtil.createFill());

        _locationUI = new TraceLocationUI();
        _locationUI.createControl(btnGroup);
        _locationUI.setEnabled(false);

        _fileUI = new TraceFileUI();
        _fileUI.createControl(btnGroup);

        _fileUI.getExternalBox().addSelectionListener(this);
        _fileUI.getFileText().addModifyListener(this);

        //_fileUI.setVisible(false);
        TRCAgentProxy agent = ((OpenProfAgentWizard) getWizard()).getAgent();

        if ((agent == null) || !agent.isActive() || (agent.isActive() && agent.isAttached())) {
            _fileUI.setEnabled(false);
            _fileUI.getExternalBox().setEnabled(false);
        }

        setControl(btnGroup);

        populateData();

        org.eclipse.ui.help.WorkbenchHelp.setHelp(parent, UIPlugin.getPluginId() + ".opaf0000");
    }

    public boolean finish() {
        TRCAgentProxy agent = ((OpenProfAgentWizard) getWizard()).getAgent();

        if ((agent == null) || !agent.isActive()) {
            return true;
        }

        if (_fileUI.getExternalBox().getSelection()) {
            agent.setProfileFile(_fileUI.getFile());
        } else {
            agent.setProfileFile(null);
        }

        /*
           if (agent.isMonitored() && agent.isToProfileFile())
           {
                   XMLTraceDataProcessor processor = (XMLTraceDataProcessor)(agent.getDataProcessor());
                   if (processor!=null)
                                           {
                                                           File processorProfilingFile = processor.getProfilingFile();
                                                           String processorProfileFileName = processor.getProfileFileName();
                                                           boolean newFile=true;
        
                                                           if (agent.getProfileFile()!=null)
                                                           {
                                                                   File testFile = new File(agent.getProfileFile());
                                                                   if (testFile.exists())  newFile=false;
                                                           }
                                                           //just attach to agent, or profile to model before
                                                           if (processorProfilingFile==null && agent.getProfileFile()!=null)
                                                           {
                                                                           processor.setProfileFileName(agent.getProfileFile());
                                                                           processor.setProfilingFile(processor.createFileWriter());
        
                                                                           if (newFile) processor.writeXMLVersion(processor.getFileWriter());
                                                                           processor.writeHeader(processor.getFileWriter());
                                                           }
                                                           //profile file name changed while stop monitor/detach, or file deleted
                                                           else if (processorProfileFileName!=null && (!processorProfileFileName.equals(agent.getProfileFile())
                                                                                   || !processorProfilingFile.exists()))
                                                           {
                                                                           if (processorProfilingFile.exists())
                                                                           processor.endTrace(processor.getFileWriter());
        
                                                                           processor.setProfileFileName(agent.getProfileFile());
                                                                           processor.setProfilingFile(processor.createFileWriter());
        
                                                                           if (newFile) processor.writeXMLVersion(processor.getFileWriter());
                                                                           processor.writeHeader(processor.getFileWriter());
                                                           }
                                           }
        
           }
         */
        if (agent.isMonitored() && agent.isToProfileFile()) {
            XMLTraceDataProcessor processor = (XMLTraceDataProcessor) LoadersUtils.locateDataProcessor(agent);

            if (processor != null) {
                String processorProfileFileName = processor.getProfileFileName();
                File processorProfilingFile = new File(processorProfileFileName);
                boolean newFile = true;

                if (agent.getProfileFile() != null) {
                    File testFile = new File(agent.getProfileFile());

                    if (testFile.exists()) {
                        newFile = false;
                    }
                }

                //just attach to agent, or profile to model before
                if ((processorProfilingFile == null) && (agent.getProfileFile() != null)) {
                    processor.setProfileFileName(agent.getProfileFile());
                    processor.createWriter();
                    newFile = processor.isNewProfileFile();

                    if (newFile) {
                        processor.writeXMLVersion(processor.getWriter());
                        processor.startTrace(processor.getWriter());
                    }
                }
                //profile file name changed while stop monitor/detach, or file deleted
                else if ((processorProfileFileName != null) && (!processorProfileFileName.equals(agent.getProfileFile()) || !processorProfilingFile.exists())) {
                    if (processorProfilingFile.exists()) {
                        processor.endTrace(processor.getWriter());
                    }

                    processor.setProfileFileName(agent.getProfileFile());
                    processor.createWriter();
					newFile = processor.isNewProfileFile();

                    if (newFile) {
                        processor.writeXMLVersion(processor.getWriter());
                        processor.startTrace(processor.getWriter());
                    }
                }
            }
        }

        return true;
    }

    /**
     * Insert the method's description here.
     * Creation date: (08/21/2000 7:51:52 PM)
     * @param event com.ibm.swt.events.ModifyEvent
     */
    public void modifyText(ModifyEvent event) {
        checkPageComplete();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        checkPageComplete();
    }

    protected void populateData() {
        IResource sel = HyadesUtil.getSelectionFolder(fViewer);

        if (sel != null) {
            _locationUI.setLocation(sel.getFullPath().toOSString());
        }

        TRCAgentProxy agent = ((OpenProfAgentWizard) getWizard()).getAgent();

        if (agent == null) {
            return;
        }

        _locationUI.setMonitor(agent.getProcessProxy().getNode().getMonitor().getName());

        if (agent.isToProfileFile()) {
            _fileUI.getExternalBox().setSelection(true);
            _fileUI.setEnabled(true);
            _fileUI.setFile(agent.getProfileFile());
        }

        if (!agent.isActive() || (agent.isActive() && agent.isAttached())) {
            _fileUI.setEnabled(false);
            _fileUI.getExternalBox().setEnabled(false);
        }
    }

    private void checkPageComplete() {
        setPageComplete(!_locationUI.getLocation().getText().trim().equals("") && !_locationUI.getMonitor().getText().trim().equals("") && (_fileUI.getSelection() ? (!_fileUI.getFile().equals("")) : true));
    }
}
