/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenProfAgentOptionsPage.java,v 1.4 2005/02/16 22:24:02 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class OpenProfAgentOptionsPage extends WizardPage {

	private static final int MARGIN_SIZE = 20;
	
	public OpenProfAgentOptionsPage(String name) {
		super(name);
		setTitle(UIPlugin.getResourceString("STR_OPTIONS_PAGE"));
		setDescription(UIPlugin.getResourceString("STR_OPTIONS_DESC"));
	}
	
	public void createControl(Composite parent) {
		GridLayout layout = new GridLayout();
		layout.marginHeight = MARGIN_SIZE;
		layout.marginWidth = MARGIN_SIZE;
		layout.numColumns = 1;

		Composite contents = new Composite(parent, SWT.NONE);
		contents.setLayout(layout);

		GridData data = new GridData(GridData.FILL_BOTH);
		data.widthHint = 200;
		data.heightHint = 200;

		contents.setLayoutData(data);
		
		Table table = new Table(contents, SWT.BORDER | SWT.FULL_SELECTION);
		table.setLayoutData(data);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);

		TableColumn propertyColumn = new TableColumn(table, SWT.NONE);
		propertyColumn.setText(UIPlugin.getResourceString("STR_OPTIONS_TABLE_PROPERTY"));
		TableColumn valueColumn = new TableColumn(table, SWT.NONE);
		valueColumn.setText(UIPlugin.getResourceString("STR_OPTIONS_TABLE_VALUE"));

		TableLayout tableLayout = new TableLayout();
		tableLayout.addColumnData(new ColumnWeightData(1));
		tableLayout.addColumnData(new ColumnWeightData(1));
		table.setLayout(tableLayout);

		// collect all the options
		List list = new ArrayList();
		TRCAgentProxy agent = ((OpenProfAgentWizard)getWizard()).getAgent();
		Iterator i = agent.getConfigurations().iterator();
		while (i.hasNext()) {
			TRCConfiguration conf = (TRCConfiguration)i.next();
			Iterator j = conf.getOptions().iterator();
			while (j.hasNext()) {
				TRCOption option = (TRCOption)j.next();
				list.add(option);
			}
		}

		// convert to array in order to sort
		TRCOption[] options = new TRCOption[list.size()];
		list.toArray(options);
		Arrays.sort(options, new Comparator() {
			public int compare(Object a, Object b) {
				return ((TRCOption)a).getKey().compareTo(((TRCOption)b).getKey());
			}
		});

		// populate the table
		TableItem collectionMode = new TableItem(table, SWT.NONE);
		collectionMode.setText(0, UIPlugin.getResourceString("AGENT_COLLECTION_MODE"));
		collectionMode.setText(1, agent.getCollectionMode().getName());
		
		for (int j=0;j<options.length;++j) {
			TableItem item = new TableItem(table, SWT.NONE);
			item.setText(0, options[j].getKey());
			item.setText(1, options[j].getValue());
		}
		
		setControl(contents);
	}
	
	public boolean finish() {
		return true;
	}
}
