/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenLogViewAction.java,v 1.17 2005/03/23 21:05:44 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.actions;

import org.eclipse.core.runtime.*;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.views.LogViewer;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.action.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;

public class OpenLogViewAction extends Action
									implements IExecutableExtension
											  , IWorkbenchWindowActionDelegate, IViewActionDelegate
											  
{
	//private ISelection selection = null;
	private IWorkbenchWindow window;
	
	public OpenLogViewAction() {
		super("");
	}
	
	private void openView() {
		try {

			PerfUtil p = new PerfUtil("openLogView",true);
			IWorkbenchWindow window =
				LogUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
			IWorkbenchPage persp = UIPlugin.getActivePage();

            EObject mofObject = HyadesUtil.getObjectToView(HyadesUtil.getMofObject());
			TraceViewer view = (LogViewer) (persp.showView("org.eclipse.hyades.log.ui.internal.views.LogViewer"));
			if (view != null)	{				
				view.addViewPage(mofObject);
			}
			
			Object obj = UIPlugin.getDefault().getSelectionModel(mofObject).getFirstElement();
			if(obj!=null && obj instanceof EObject)
			   view.setRecordSelection((EObject)obj, mofObject);
			p.stopAndPrintStatus();
            
		} catch (Exception e) {
			
			e.printStackTrace();
		}		
	}
	public void run() {
		openView();
	}
	public void run(IAction action) {
		run();
	}
	public void setInitializationData(
		IConfigurationElement configElement,
		String name,
		Object data) {
	}
	public void selectionChanged(IAction action, ISelection selection) {
		//this.selection = selection;		
	}

	public void dispose() {
		
	}
	public void init(IWorkbenchWindow window) {
		
	}
	
	

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	public void init(IViewPart view) {

	}

}