/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SaveAction.java,v 1.3 2005/02/16 22:20:27 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Apr 13, 2004
 *
 */
package org.eclipse.hyades.log.ui.internal.actions;

import java.util.List;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

/**
 * @author apnan
 *
 */
public class SaveAction
		extends
			org.eclipse.hyades.trace.ui.internal.actions.SaveAction {
	
	public SaveAction(INavigator viewer) {
		super(viewer);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.actions.SelectionProviderAction#getSelection()
	 */
	public ISelection getSelection() {
		INavigator viewer = getViewer();
		ISelection sel = viewer.getViewer().getSelection();
		List selObjects =  new UniqueEList();
		if(sel!=null && sel instanceof IStructuredSelection && !((IStructuredSelection)sel).isEmpty()){
			List selection = ((IStructuredSelection)sel).toList();
			Object item = null;
			
			for(int i=0;i<selection.size();i++){
				item = selection.get(i);
				if(item instanceof LogicalFolder)
					selObjects.addAll(((LogicalFolder)item).getChildren());
				else
					selObjects.add(item);
			}
			return new StructuredSelection(selObjects);
		}		
		return sel;
	}
}
