/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogAnalyzerSortPrefPage.java,v 1.7 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.preferences;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.log.ui.internal.util.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;
import org.eclipse.ui.help.*;

public class LogAnalyzerSortPrefPage{

	private CBESortUI _options;
	private IPreferenceStore _preferenceStore;
	private boolean sortHasChanged = false;

	public LogAnalyzerSortPrefPage(IPreferenceStore preferenceStore) {
		super();
		_preferenceStore = preferenceStore;
	}
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);
		GridData data = GridUtil.createFill();
		composite.setLayoutData(data);

		_options = new CBESortUI(LogUIPlugin.getDefault().getPreferenceStore());
		_options.createControl(composite);
		//_options.addListener(this);		

		initializeValues();

		WorkbenchHelp.setHelp(composite, ContextIds.ACTLOG_PREF_SORT_RECORDS);

		return composite;
	}
	/**
	 * Returns preference store that belongs to the our plugin.
	 * This is important because we want to store
	 * our preferences separately from the desktop.
	 *
	 * @return the preference store for this plugin
	 */
	protected IPreferenceStore doGetPreferenceStore() {
		return LogUIPlugin.getDefault().getPreferenceStore();
	}
	public void init(IWorkbench workbench) {
	}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {

		_options.initializeValues(true);
	}
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {

		_options.initializeValues(false);
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		initializeDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		return true;
	}
	
	public void performApply(){
		_options.applyValues(_preferenceStore);
		LogUIPlugin.getDefault().savePluginPreferences();
				
	}
	public boolean hasSortChanged(){
		return !_preferenceStore.getString(LogUIConstants.PD_SORT_LOG_OPTIONS).equals(_options.getPreferenceString());
	}
	
	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues() {
		_options.storeValues();
	}
}