/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ContextIds.java,v 1.8 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.log.ui.internal.*;

public interface ContextIds {
	// Constant for the RAS plug-in id.
	public static final String PLUGIN_ID = LogUIPlugin.getPluginId();

	// Context help ID constants for the Activity Log preferences page.
	public static final String ACTLOG_PREF_FORMAT_DATE = PLUGIN_ID + ".alpp0010";
	public static final String ACTLOG_PREF_FORMAT_TIME = PLUGIN_ID + ".alpp0020";
	public static final String ACTLOG_PREF_SORT_RECORDS = PLUGIN_ID + ".alpp0110";
	public static final String ACTLOG_PREF_FILTER_PROPERTIES = PLUGIN_ID + ".alpp0210";

	// Context help ID constants for the Symptom Database preferences page.
	public static final String SYMDB_PREF_DATABASE = PLUGIN_ID + ".sdpp0010";
	public static final String SYMDB_PREF_DATABASE_ADD_DIALOG = PLUGIN_ID + ".sdpp0020";
	public static final String SYMDB_PREF_URL = PLUGIN_ID + ".sdpp0110";
	public static final String SYMDB_PREF_URL_ADD_DIALOG_NAME = PLUGIN_ID + ".sdpp0120";
	public static final String SYMDB_PREF_URL_ADD_DIALOG_URL = PLUGIN_ID + ".sdpp0130";
	public static final String SYMDB_PREF_URL_EDIT_DIALOG_NAME = PLUGIN_ID + ".sdpp0140";
	public static final String SYMDB_PREF_URL_EDIT_DIALOG_URL = PLUGIN_ID + ".sdpp0150";

	// Context help ID constants for the Logging Agents preferences page.
	public static final String LOGAGENTS_PREF_AGENT_LIST = PLUGIN_ID + ".lapp0010";
	public static final String LOGAGENTS_PREF_ADD_AGENT = PLUGIN_ID + ".lapp0020";

	// Context help ID constants for importing log file.
	public static final String IMPORT_LOG_FILE_HOST_LIST = PLUGIN_ID + ".iwlg0010";
	public static final String IMPORT_LOG_FILE_HOST_ADDRESS = PLUGIN_ID + ".iwlg0020";
	public static final String IMPORT_LOG_FILE_IBM_RAC_PORT = PLUGIN_ID + ".iwlg0030";
	public static final String IMPORT_LOG_FILE_WAS_HOME = PLUGIN_ID + ".iwlg0040";
	public static final String IMPORT_LOG_FILE_LOG_FILE = PLUGIN_ID + ".iwlg0050";
	public static final String IMPORT_LOG_FILE_PROJECT = PLUGIN_ID + ".iwlg0060";
	public static final String IMPORT_LOG_FILE_MONITOR = PLUGIN_ID + ".iwlg0070";

	// Context help ID constants for the Activity Log view.
	public static final String ACTLOG_VIEW_PANE_LOG = PLUGIN_ID + ".algv0010";
	public static final String ACTLOG_VIEW_PANE_RECORD = PLUGIN_ID + ".algv0020";
	public static final String ACTLOG_VIEW_PANE_ANALYSIS = PLUGIN_ID + ".algv0030";
	public static final String ACTLOG_VIEW_POPUP_ANALYZE = PLUGIN_ID + ".algv0110";
	public static final String ACTLOG_VIEW_POPUP_RELOAD_SYMDB = PLUGIN_ID + ".algv0120";
	public static final String ACTLOG_VIEW_POPUP_LOAD_SYMDB = PLUGIN_ID + ".algv0130";
	public static final String ACTLOG_VIEW_POPUP_REFRESH = PLUGIN_ID + ".algv0140";
	public static final String ACTLOG_VIEW_DIALOG_SORT = PLUGIN_ID + ".algv0210";
	public static final String ACTLOG_VIEW_DIALOG_FILTER = PLUGIN_ID + ".algv0310";
	public static final String ACTLOG_VIEW_DIALOG_FILTER_ERROR = PLUGIN_ID + ".algv0320";
	public static final String ACTLOG_VIEW_DIALOG_FILTER_WARNING = PLUGIN_ID + ".algv0330";
	public static final String ACTLOG_VIEW_DIALOG_FILTER_INFORMATION = PLUGIN_ID + ".algv0340";

	// Context help ID constants for the Log view advanced filter dialog	
	public static final String ACTLOG_VIEW_DIALOG_ADV_FILTER_ADD = PLUGIN_ID + ".algv0410";
	public static final String ACTLOG_VIEW_DIALOG_ADV_FILTER_EDIT = PLUGIN_ID + ".algv0420";
	public static final String ACTLOG_VIEW_DIALOG_ADV_FILTER_REMOVE = PLUGIN_ID + ".algv0430";
	public static final String ACTLOG_VIEW_DIALOG_ADV_FILTER_UP = PLUGIN_ID + ".algv0440";
	public static final String ACTLOG_VIEW_DIALOG_ADV_FILTER_DOWN = PLUGIN_ID + ".algv0450";
	public static final String ACTLOG_VIEW_DIALOG_ADV_FILTER_TABLE = PLUGIN_ID + ".algv0460";
	
	// Context help ID constants for the Log view search dialog	
	public static final String ACTLOG_VIEW_DIALOG_SEARCH_ADD = PLUGIN_ID + ".algv0610";
	public static final String ACTLOG_VIEW_DIALOG_SEARCH_EDIT = PLUGIN_ID + ".algv0620";
	public static final String ACTLOG_VIEW_DIALOG_SEARCH_REMOVE = PLUGIN_ID + ".algv0630";
	public static final String ACTLOG_VIEW_DIALOG_SEARCH_MOVE_UP = PLUGIN_ID + ".algv0640";
	public static final String ACTLOG_VIEW_DIALOG_SEARCH_MOVE_DOWN = PLUGIN_ID + ".algv0650";	
	public static final String ACTLOG_VIEW_DIALOG_SEARCH_UP = PLUGIN_ID + ".algv0660";
	public static final String ACTLOG_VIEW_DIALOG_SEARCH_DOWN = PLUGIN_ID + ".algv0670";

	// Context help ID constants for the Log interactions view search dialog	
	public static final String LOGINTER_VIEW_DIALOG_FILTER = PLUGIN_ID + ".lgiv0100";
	public static final String LOGINTER_VIEW_DIALOG_SEARCH_ADD = PLUGIN_ID + ".lgiv0010";
	public static final String LOGINTER_VIEW_DIALOG_SEARCH_EDIT = PLUGIN_ID + ".lgiv0020";
	public static final String LOGINTER_VIEW_DIALOG_SEARCH_REMOVE = PLUGIN_ID + ".lgiv0030";
	public static final String LOGINTER_VIEW_DIALOG_SEARCH_MOVE_UP = PLUGIN_ID + ".lgiv0040";
	public static final String LOGINTER_VIEW_DIALOG_SEARCH_MOVE_DOWN = PLUGIN_ID + ".lgiv0050";	
	
	// Context help ID constants for the Activity Log view search dialog
	public static final String ACTLOG_VIEW_DIALOG_SEARCH = PLUGIN_ID + ".algv0510";
	
	// Context help ID constants for the Log Navigator
	public static final String LOG_NAVIGATOR_VIEW = PLUGIN_ID + ".lognav0010";
	
	// Context help ID constants for the New Correlation Wizard
	public static final String NEW_CORR_WIZARD_CORRNAME = PLUGIN_ID + ".newcorrwizname";
	public static final String NEW_CORR_WIZARD_LOGS = PLUGIN_ID + ".newcorrwizlogs";
	public static final String NEW_CORR_WIZARD_SCHEMA_SEL = PLUGIN_ID + ".corrschema0000";

}