/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FiltersDialog.java,v 1.11 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFilterProvider;
import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class FiltersDialog extends Dialog //implements SelectionListener
{
	private CBEAdvFilterUI _filters;
	private FilterOptionsUI _options;
	private static final int _restoreDefaultsButtonId = IDialogConstants.CLIENT_ID + 1;

	private Composite optionsComposite;
	private boolean showOptions = false;
	
	private ILogFilterProvider logFilterProvider = null;
	private LogFilterCriteria criteria = null;

	private java.lang.String _title;
	/**
	 * CoulmnsDialog constructor comment.
	 * @param windowTitle java.lang.String
	 * @param windowImage com.ibm.swt.graphics.Image
	 */
	public FiltersDialog(Shell shell, String windowTitle, Image windowImage, ILogFilterProvider logFilterProvider, boolean showOptions) {
		super(shell);
		_title = windowTitle;
		setDefaultImage(windowImage);
		this.logFilterProvider = logFilterProvider;
		this.showOptions = showOptions;
	}
	/**
	 * Configures the given shell in prepartaion for opening this window
	 * in it.
	 * <p>
	 * The default implementation of this framework method
	 * sets the shell's image and gives it a grid layout. 
	 * Subclasses may extend or reimplement.
	 * </p>
	 * 
	 * @param newShell the shell
	 */
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(_title);
	}
	/**
	 * Creates and returns the contents of the upper part 
	 * of the dialog (above the button bar).
	 *
	 * Subclasses should overide.
	 *
	 * @param the parent composite to contain the dialog area
	 * @return the dialog area control
	 */
	protected Control createDialogArea(Composite parent) {
		Composite result = (Composite) super.createDialogArea(parent);

		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 0;
		result.setLayout(layout);
		data = GridUtil.createFill();
		/* If width is specified, text gets cut out
		 * when font is larger. Bug #61460
		 */ 
		//data.widthHint = 500;
		result.setLayoutData(data);

		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		_filters =  new CBEAdvFilterUI(showOptions?LogUIConstants.FILTER_LOG_INTER:LogUIConstants.FILTER_LOG_VIEW, LogUIPlugin.getDefault().getPreferenceStore());
		_filters.createControl(result);
		_filters.initializeValues(false);
		
		_options = new FilterOptionsUI();
		optionsComposite = _options.createControl(result);

		initializeOptionsComposite();

		if(showOptions)	
			WorkbenchHelp.setHelp(result, ContextIds.LOGINTER_VIEW_DIALOG_FILTER);
		else	
			WorkbenchHelp.setHelp(result, ContextIds.ACTLOG_VIEW_DIALOG_FILTER);

		return result;
	}
	
	private void initializeOptionsComposite() {
		optionsComposite.setVisible(showOptions);
		if (showOptions) _options.initializeValues(false);
	}

	protected void createButtonsForButtonBar(Composite parent) {
		createButton(
			parent,
			_restoreDefaultsButtonId,
			LogUIPlugin.getResourceString("STR_COL_DLG_RESTORE_DEFAULTS"),
			false);
		super.createButtonsForButtonBar(parent);
	}
	protected void buttonPressed(int buttonId) {
		if (buttonId == _restoreDefaultsButtonId) {
			_filters.initializeValues(true);
			_options.initializeValues(true);
		} else {
			super.buttonPressed(buttonId);
		}

	}
	/**
	 * Notifies that the ok button of this dialog has been pressed.
	 * <p>
	 * The default implementation of this framework method sets
	 * this dialog's return code to <code>Window.OK</code>
	 * and closes the dialog. Subclasses may override.
	 * </p>
	 */
	protected void okPressed() {
		boolean filterChanged = _filters.storeValues();
		
		Map options = new HashMap();		
		options.put(ILogFilterCriteria.OPTION_ONLY_CORRELATED, _options.getShowCorrelationButton().getSelection()?"1":"0");
		if(showOptions && !LogUIPlugin.getDefault().getPreferenceStore().getString(LogUIConstants.PD_FILTER_SHOW_CORRELATION_ONLY).equals(options.get(ILogFilterCriteria.OPTION_ONLY_CORRELATED))){
			filterChanged = true;
		}

		if (showOptions) _options.storeValues();
		criteria = new LogFilterCriteria();
		List filters = _filters.getFilterList().getFilters();
		int s = filters.size();
		criteria.setFilters((IFilterElement[])filters.toArray(new IFilterElement[s]));
		
		criteria.setFilterOptions(options);

		if (logFilterProvider!=null && filterChanged){
			//logFilterProvider.filterRecord(criteria);
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.FILTER_ADV_CHANGE, logFilterProvider));
		}
		super.okPressed();
	}
}