/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogAnalyzerUI.java,v 1.8 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import java.util.*;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/**
 * 
 */
public abstract class LogAnalyzerUI implements SelectionListener{

	private Button _moveUp;
	protected Button _moveDown;
	public Button _selAll;
	public Button _unselAll;	
	private Label _description;
	private Label _label;
	public Label _labelMessage;

	private HashMap _map;
	protected ArrayList _pdData = new ArrayList();
	public Table _pdList;
	protected IPreferenceStore _store;
	
	private ArrayList listeners = new ArrayList(2);
	
	/**
	 * Constructor for LogAnalyzerUI.
	 */
	public LogAnalyzerUI(IPreferenceStore store) {
		_store = store;
	}

	
	public Control createControl(Composite parent) {
				
		GridLayout layout;
		GridData data;
		
		Composite result = createContainer(parent);

		_description = new Label(result, SWT.NONE);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;
		_description.setLayoutData(data);		

		_map = new HashMap();
		_pdList = createTable(result);

		Composite buttonWidget = new Composite(result, SWT.NULL);
		data = new GridData();
		data.grabExcessVerticalSpace = true;
		data.horizontalIndent = 20;
		data.verticalAlignment = GridData.FILL;		
		buttonWidget.setLayoutData(data);
		GridLayout blayout = new GridLayout();
		blayout.numColumns = 1;
		blayout.marginHeight = 25;
		buttonWidget.setLayout(blayout);

		_moveUp = createButton(buttonWidget, LogUIPlugin.getResourceString("STR_COL_DLG_UP"));
		_moveDown = createButton(buttonWidget, LogUIPlugin.getResourceString("STR_COL_DLG_DOWN"));
		_selAll = createButton(buttonWidget, LogUIPlugin.getResourceString("STR_COL_DLG_SEL_ALL"));
		_unselAll = createButton(buttonWidget, LogUIPlugin.getResourceString("STR_COL_DLG_USEL_ALL"));

		_pdList.addSelectionListener(this);
		//_wasList.addSelectionListener(this);
		_moveUp.addSelectionListener(this);
		_moveDown.addSelectionListener(this);
		_selAll.addSelectionListener(this);
		_unselAll.addSelectionListener(this);

		_moveUp.setEnabled(false);
		_moveDown.setEnabled(false);
			
		_labelMessage = new Label(result, SWT.None);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 1;
		_labelMessage.setLayoutData(data);
		
		
		return result;
	}

	private Composite createContainer(Composite parent){

		Composite result = new Composite(parent, SWT.NONE);

		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 2;
		layout.verticalSpacing = 15;
		result.setLayout(layout);
		data = GridUtil.createFill();
		data.heightHint = 350;
		data.widthHint = 350;
		result.setLayoutData(data);
		return result;
	
	}
	
	private Table createTable(Composite container){

		GridData data;
	
		Composite listGrp = new Composite(container, SWT.NULL);
		listGrp.setLayoutData(GridUtil.createFill());
		listGrp.setLayout(new GridLayout());		

		Table _list = new Table(listGrp, SWT.BORDER | SWT.CHECK | SWT.H_SCROLL);
		data = GridUtil.createFill();
		_list.setLayoutData(data);
		
		return _list;
	
	}
	
	private Button createButton(Composite parent, String label){

		GridData data;
		Button btn = new Button(parent, SWT.NULL);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		btn.setLayoutData(data);
		btn.setText(label);
		return btn;
	
	}
	
	protected void setDescription(String descr){
		_description.setText(descr);	
	}
	
	protected void setLabel(String label){
		_label.setText(label);
	}
	
	protected void moveDown(int idx, Table _list) {
		TableItem item = _list.getItem(idx);
		ColumnData data = (ColumnData) item.getData();
		TableItem newitem = new TableItem(_list, SWT.CHECK, idx + 2);
		newitem.setChecked(item.getChecked());
		newitem.setText(item.getText());

		newitem.setData(data);

		newitem.setGrayed(item.getGrayed());

		_list.remove(idx);

		_list.select(idx + 1);

	}
	protected void moveUp(int idx, Table _list) {
		TableItem item = _list.getItem(idx);

		ColumnData data = (ColumnData) item.getData();

		if (idx > 0) {
			TableItem previousItem = _list.getItem(idx - 1);
			ColumnData previousItemData = (ColumnData) previousItem.getData();
		}

		TableItem newitem = new TableItem(_list, SWT.CHECK, idx - 1);
		newitem.setChecked(item.getChecked());
		newitem.setText(item.getText());

		newitem.setData(data);
		newitem.setGrayed(item.getGrayed());

		_list.remove(idx + 1);

		_list.select(idx - 1);
	}
	
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		
		notifyListeners(e);
		if (e.widget == _moveUp) {
			
			int idx = _pdList.getSelectionIndex();

			if (idx > 0)
				moveUp(idx, _pdList);
		} else if (e.widget == _moveDown) {
			int idx = _pdList.getSelectionIndex();

			if (idx != -1 && (idx < _pdList.getItemCount() - 1))
				moveDown(idx, _pdList);
		} else if (e.widget == _selAll) {
			for (int idx = 0; idx < _pdList.getItemCount(); idx++) {
				TableItem item = _pdList.getItem(idx);
				item.setChecked(true);
			}

			return;

		} else if (e.widget == _unselAll) {
			for (int idx = 0; idx < _pdList.getItemCount(); idx++) {
				TableItem item = _pdList.getItem(idx);
				item.setChecked(false);
			}	
								
			return;
			
		}

		int idx = _pdList.getSelectionIndex();

		ColumnData data = null;
		ColumnData previousData = null;
		if (idx > 0) {
			previousData = (ColumnData) _pdList.getItem(idx - 1).getData();
		}
		if (idx != -1) {
			data = (ColumnData) _pdList.getItem(idx).getData();
		}
		_moveUp.setEnabled(data != null && previousData != null);
		_moveDown.setEnabled(data != null && (idx < _pdList.getItemCount() - 1));
				
	}
	
	public void addListener(SelectionListener listener){
		if(!listeners.contains(listener)){
			listeners.add(listener);		
		}
	}
	
	public void removeListener(SelectionListener listener){
		listeners.remove(listener);
	}
	
	public void notifyListeners(SelectionEvent e){
		for(int i=0;i<listeners.size();i++){
			((SelectionListener)listeners.get(i)).widgetSelected(e);
		}
	}
	
	protected void createColumnDataFromString(String filter, ArrayList _data){
		_data.clear();
		ArrayList list = ColumnData.createColumnDataFromString(filter);
		if(list!=null){
			_data.addAll(list);
		}
		
	}	

	protected void loadColumnData(String _filter, ArrayList _data, Table _list, IPreferenceStore store){
		store.setValue(_filter, getPreferenceString(_data,_list));		
	}
	
	protected String getPreferenceString(ArrayList _data, Table _list){
		_data.clear();

		for (int idx = 0; idx < _list.getItemCount(); idx++) {
			TableItem item = _list.getItem(idx);
			_data.add(new ColumnData(item.getText(), item.getChecked()));
		}
		return ColumnData.getPreferenceString(_data);
	}

	protected abstract void populateList();
	/**
	 * 
	 * @return boolean indicating wether the preference value has changed
	 */
	public abstract boolean storeValues();
	
	public abstract void initializeValues(boolean defaultValue);
	

}
