/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogUtil.java,v 1.10 2005/05/13 02:38:18 apnan Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.trace.internal.ui.PDPerspective;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;

public class LogUtil {
	
	public static boolean selectInLogNavigator(EObject object) {
		if (object!=null) {
			Navigator nav = (Navigator)HyadesUtil.getActiveNavigator();
			IViewPart part = null;

			IWorkbench workbench = LogUIPlugin.getDefault().getWorkbench();
			IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
			
			if(!(nav instanceof LogNavigator)){
				try {
					if(page != null && !page.getPerspective().getId().equals(PDPerspective.ID_TRACE_PERSPECTIVE) ){
						IAdaptable element =
						ResourcesPlugin.getWorkspace().getRoot();
						if (element != null)
							page =
								workbench.showPerspective(
									PDPerspective.ID_TRACE_PERSPECTIVE,
									workbench.getActiveWorkbenchWindow(),
									element);
									
					}
					part = page.findView(PDPerspective.ID_LOG_NAVIGATOR_VIEW);

				} catch (Exception e) {
					
					e.printStackTrace();
				}
						
			}else{		
				part = nav;
			}
			
			final EObject selection = object;
			final IViewPart fPart = part;
			
			final IWorkbenchPage fPage = page;
			if(fPart!=null){

				Display.getDefault().asyncExec(new Runnable()
				{
					public void run()
					{						
						((LogNavigator)fPart).selectReveal(new StructuredSelection(selection));
						if(!((LogNavigator)fPart).isActiveNavigator()){
							try{	
								fPage.showView(PDPerspective.ID_LOG_NAVIGATOR_VIEW);
							}
							catch(Exception e){
								e.printStackTrace();
							}
						}
					}
				});						
			}
		}
		return false;
	}

	public static void notifyViewSelectionChanged(Object source, Object selection) {
		UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).add(selection);
			
		ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
		event.setSource(source);
		UIPlugin.getDefault().notifyViewSelectionChangedListener(event);
	}
	
	
	public static void initializePreferenceStore(IPreferenceStore store){
	try {

		ArrayList sort = new ArrayList(40);
		ArrayList filter = new ArrayList(70);

		createSortAndFilterList(sort,filter,CBEPackage.eINSTANCE.getCBECommonBaseEvent());

		sort.remove("timeZone");
		sort.remove("adjustedCreationTime");
		StringBuffer pdSortKey = new StringBuffer();
		generatePreferenceString(pdSortKey, sort, new String[]{"creationTime", "sequenceNumber"});
		store.setDefault(LogUIConstants.PD_SORT_LOG_OPTIONS, pdSortKey.toString().trim());
		
		filter.remove("timeZone");
		filter.remove("adjustedCreationTime");
		StringBuffer pdKey = new StringBuffer();					
		Collections.sort(filter);
		generatePreferenceString(pdKey, filter, null);
		store.setDefault(LogUIConstants.PD_FILTER_OPTIONS, pdKey.toString().trim());
	
		store.setDefault(LogUIConstants.PD_ADV_FILTER_OPTIONS, "");
		store.setDefault(LogUIConstants.PD_SEARCH_FILTER_OPTIONS, "");
		store.setDefault(LogUIConstants.PD_SEARCH_DIRECTION_OPTIONS, "1");
		store.setDefault(LogUIConstants.PD_FILTER_SHOW_CORRELATION_ONLY, "1");
			
} catch (Exception exc) {
	exc.printStackTrace();
}

		
store.setDefault(LogUIConstants.LOG_ANALYZER_FORMAT_DATE, LogUIConstants.LOG_ANALYZER_FORMAT_DATE_DEFAULT);
store.setDefault(LogUIConstants.LOG_ANALYZER_FORMAT_TIME, LogUIConstants.LOG_ANALYZER_FORMAT_TIME_DEFAULT);

}
	
	/**
	 * Method generatePrefrenceString.
	 * @param key
	 * @param list
	 */
	private static void generatePreferenceString(StringBuffer key, ArrayList list, String[] pref) {
		
		String keyVal = "";
		if(pref==null){
			keyVal = ":1 ";
		}
		else{
			keyVal = ":1 ";
			int s = pref.length;
			for(int i=0; i<s; i++){
				key.append((String)pref[i]);
				key.append(keyVal);
				list.remove(pref[i]);
			}
			keyVal = ":0 ";
			
		}
		
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			String element = (String) iter.next();
			key.append(element);
			key.append(keyVal);
			
		}
	}

	
	private static void createSortAndFilterList(List sort, List filter, EClassifier base){

		List list = new ArrayList(30);
			
		EList metaObj = CBEPackage.eINSTANCE.getEClassifiers();
		int size = metaObj.size();

		for (int i = 0; i < size; i++) {
			EClassifier elem = (EClassifier)metaObj.get(i);
			getEObjectAttributes((EClass)elem, list);
			int listSize = list.size();
			boolean isSort = ((EClass)elem).getEAllSuperTypes().contains(base) || elem == base;			
			for (int j = 0; j<listSize;j++) {
				String element = (String) list.get(j);
				if(isSort && !sort.contains(element)){
					sort.add(element);
				}
				if(!filter.contains(element)){
					filter.add(element);
				}
				
			}
			list.clear();

		}
				
	}
	
	
	private static void getEObjectAttributes(EClass eClass, List list){

		List attributes = eClass.getEAttributes();
		boolean isArrayOfObj = false;
		for (int k=0; k < attributes.size(); k++) {
			EAttribute attribute = (EAttribute) attributes.get(k);
			isArrayOfObj = attribute.isMany() &&  
							(attribute.getEType().getInstanceClass() != String.class) &&
							(!attribute.getEType().getInstanceClassName().equals("byte")) && 
							(!attribute.getEType().getInstanceClassName().equals("short"));
			if(!isArrayOfObj){
				list.add(attribute.getName());
			}
		}
					
	}	
}
