/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecordChangeEvent.java,v 1.7 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.util;

/**
 * 
 */
public class RecordChangeEvent {
	
	private int type;
	private Object source;
	public static final int FILTER_COL_CHANGE = 1;
	public static final int FILTER_SEV_CHANGE = 2;	
	public static final int PROPERTY_CHANGE = 3;
	public static final int SORT_COL_CHANGE = 4; 
	public static final int FILTER_ADV_CHANGE = 5;
	public static final int REFRESH = 6;
		
	public RecordChangeEvent(){
	}

	public RecordChangeEvent(int type, Object source){
		this.type = type;
		this.source = source;
	}
	
	/**
	 * @return int
	 */
	public int getType(){
		return type;
	}
	
	/**
	 * Sets the type.
	 * @param type The type to set
	 */	
	public void setType(int type){
		this.type = type;		
	}
	
	/**
	 * @return Object
	 */
	public Object getSource() {
		return source;
	}

	/**
	 * Sets the source.
	 * @param source The source to set
	 */
	public void setSource(Object source) {
		this.source = source;
	}

}
 
