/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceMergeUIDialog.java,v 1.4 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

/**
 * 
 */
public class TraceMergeUIDialog extends Dialog{

	private Button _chkAppend;
	private Button _chkReplace;
	private String msg;

	
	/**
	 * @param parentShell
	 */
	public TraceMergeUIDialog(Shell parentShell, String msg) {
		super(parentShell);
		this.msg = msg;
		//setShellStyle(getShellStyle() | SWT.RESIZE);		
	}


	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
	 */
	protected void okPressed() {
		setReturnCode(_chkAppend.getSelection()? 2: 3);
		close();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createDialogArea(Composite parent) {

		GridLayout layout;
		GridData   data;
	
		Composite result = new Composite(parent, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 1;

		result.setLayout(layout);
		data = GridUtil.createFill();
		result.setLayoutData(data);
		createAppendGroup(result);
		getShell().setText(LogUIPlugin.getResourceString("RAS_MSG"));
		
		return result;

	}

	private void createAppendGroup(Composite result){

		Composite grpAppend = new Composite(result, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		grpAppend.setLayout(layout);
	
		Label lblAppendGrp = new Label(grpAppend, SWT.WRAP);
		//lblAppendGrp.setText(LogUIPlugin.getResourceString("STR_EXISTING_DATA_DESC"));
		GridData data = GridUtil.createHorizontalFill();
		int i = convertWidthInCharsToPixels(LogUIPlugin.getResourceString("STR_EXISTING_DATA_APPEND").length());
		int j = convertWidthInCharsToPixels(LogUIPlugin.getResourceString("STR_EXISTING_DATA_REPLACE").length());
		int len = 3*convertWidthInCharsToPixels(msg.length())/4;
		int max = Math.max(i,j) + Math.max(i,j)/2; 
 
		if(len > max){
			data.widthHint = len;		
		}
		else{			
			data.widthHint = max;		
		}
			
		lblAppendGrp.setLayoutData(data);
		lblAppendGrp.setText(msg);
			
		_chkAppend = new Button(grpAppend, SWT.RADIO | SWT.WRAP);
		
		_chkAppend.setText(LogUIPlugin.getResourceString("STR_EXISTING_DATA_APPEND"));
		_chkAppend.setSelection(true);
		
		data = GridUtil.createHorizontalFill();
		data.horizontalIndent = 15;
		_chkAppend.setLayoutData(data);
	
		_chkReplace = new Button(grpAppend, SWT.RADIO | SWT.WRAP);
				
		_chkReplace.setText(LogUIPlugin.getResourceString("STR_EXISTING_DATA_REPLACE"));
		data = GridUtil.createHorizontalFill();
		data.horizontalIndent = 15;
		_chkReplace.setLayoutData(data);
		
	}
	
	protected Control createButtonBar(Composite parent){
		Composite buttonBar = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		buttonBar.setLayout(layout);
		GridData data = GridUtil.createHorizontalFill();
		buttonBar.setLayoutData(data);		
		
		createButton(
		buttonBar,
		IDialogConstants.OK_ID,
		IDialogConstants.OK_LABEL,
		true);
		
		createButton(
		buttonBar,
		IDialogConstants.CANCEL_ID,
		IDialogConstants.CANCEL_LABEL,
		true);
		
		return buttonBar;
	}
	
	/**
	 * Set the layout data of the button to a GridData with 
	 * appropriate heights and widths.
	 * @param button
	 */
	protected void setButtonLayoutData(Button button) {
		GridData data = new GridData();
		data.horizontalAlignment = GridData.CENTER;
		data.grabExcessHorizontalSpace = true;
		
		data.heightHint =
			convertVerticalDLUsToPixels(IDialogConstants.BUTTON_HEIGHT);
		int widthHint =
			convertHorizontalDLUsToPixels(IDialogConstants.BUTTON_WIDTH);
		data.widthHint =
			Math.max(
				widthHint,
				button.computeSize(SWT.DEFAULT, SWT.DEFAULT, true).x);
		button.setLayoutData(data);
	}

	

}
