/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TreeNode.java,v 1.4 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.emf.ecore.EObject;

/**
 * @author apnan
 *
 * Object used to represent additional features, not contained in the CBE model, in the Log Viewer that cannot be represented as FeatureNodes
 **/
public class TreeNode {
	
	private EObject parent;
	private Object element;
	
	public TreeNode(EObject parent, Object element){
		this.parent = parent;
		this.element = element;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object arg0) {

		if(arg0 instanceof TreeNode){
			if(((TreeNode)arg0).getElement().equals(element) && ((TreeNode)arg0).getParent().equals(parent)){
				return true;	
			}
			else{
				return false;
			}
		}
		return super.equals(arg0);		
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {

		return element.hashCode();
	}

	/**
	 * @return Returns the element.
	 */
	public Object getElement() {
		return element;
	}
	/**
	 * @param element The element to set.
	 */
	public void setElement(Object element) {
		this.element = element;
	}
	/**
	 * @return Returns the parent.
	 */
	public EObject getParent() {
		return parent;
	}
	/**
	 * @param parent The parent to set.
	 */
	public void setParent(EObject parent) {
		this.parent = parent;
	}
}
