/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.trace.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.hyades.trace.ui.filters.IFilterAttribute;
import org.eclipse.hyades.trace.ui.internal.filters.BasicFeatureFilterAttribute;



public class ImportLogAdvancedTabAttributeSet implements IAdvancedTabAttributeSet
{
	private static RelationalOperators[] _operators = new RelationalOperators[]
    {
		RelationalOperators.get(RelationalOperators.EQ),
		RelationalOperators.get(RelationalOperators.LIKE),
		RelationalOperators.get(RelationalOperators.NEQ),
		RelationalOperators.get(RelationalOperators.GT),
		RelationalOperators.get(RelationalOperators.LT),
		RelationalOperators.get(RelationalOperators.GE),
		RelationalOperators.get(RelationalOperators.LE)
    };	
	
	private IFilterAttribute[] _attributes = new IFilterAttribute[]
	{
		new CreationTimeFeatureFilterAttribute("ft_log1", LogUIPlugin.getResourceString("STR_FILTER_ADVANCED_CREATION_TIME")+"(yyyy-MM-dd HH:mm:ss.STZD)"),
		new BasicFeatureFilterAttribute("ft_implog2", LogUIPlugin.getResourceString("STR_FILTER_ADVANCED_ELAPSED_TIME"), CBEPackage.eINSTANCE.getCBECommonBaseEvent_ElapsedTime(), _operators, true),
		new BasicFeatureFilterAttribute("ft_implog3", LogUIPlugin.getResourceString("STR_FILTER_ADVANCED_GLOBAL_INSTANCE_ID"), CBEPackage.eINSTANCE.getCBECommonBaseEvent_GlobalInstanceId(), _operators, true),
		new BasicFeatureFilterAttribute("ft_implog4", LogUIPlugin.getResourceString("STR_FILTER_ADVANCED_LOCAL_INSTANCE_ID"), CBEPackage.eINSTANCE.getCBECommonBaseEvent_LocalInstanceId(), _operators, true),			
		new BasicFeatureFilterAttribute("ft_implog5", LogUIPlugin.getResourceString("STR_FILTER_ADVANCED_MSG"), CBEPackage.eINSTANCE.getCBECommonBaseEvent_Msg(), _operators, true),
		new BasicFeatureFilterAttribute("ft_implog6", LogUIPlugin.getResourceString("STR_FILTER_ADVANCED_PRIORITY"), CBEPackage.eINSTANCE.getCBECommonBaseEvent_Priority(), _operators, true),
		new BasicFeatureFilterAttribute("ft_implog7", LogUIPlugin.getResourceString("STR_FILTER_ADVANCED_REPEAT_COUNT"), CBEPackage.eINSTANCE.getCBECommonBaseEvent_RepeatCount(), _operators, true),
		new BasicFeatureFilterAttribute("ft_implog8", LogUIPlugin.getResourceString("STR_FILTER_ADVANCED_SEQUENCE_NUMBER"), CBEPackage.eINSTANCE.getCBECommonBaseEvent_SequenceNumber(), _operators, true),
		new BasicFeatureFilterAttribute("ft_implog9", LogUIPlugin.getResourceString("STR_FILTER_ADVANCED_SEVERITY"), CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), _operators, true),
		new BasicFeatureFilterAttribute("ft_implog10", LogUIPlugin.getResourceString("STR_FILTER_ADVANCED_VERSION"), CBEPackage.eINSTANCE.getCBECommonBaseEvent_Version(), _operators, true)			
	};

	public ImportLogAdvancedTabAttributeSet()
	{
		//initializeAttribute();
	}

	public IFilterAttribute[] getAttributes() {
		return _attributes;
	}
	
//	public void initializeAttribute() {
//		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
//		String pdFilters = store.getString(LogUIConstants.PD_FILTER_OPTIONS);			
//		ArrayList tempList = new ArrayList();
//
//		ArrayList list = ColumnData.createColumnDataFromString(pdFilters);
//			if(list!=null){
//				for (int i=0;i<list.size();i++)
//				{
//					ColumnData data = (ColumnData)(list.get(i));
//					tempList.add(data.name());	
//						
//				} 
//			}
//		Collections.sort(tempList);
//		
//		List featureList = CBEPackage.eINSTANCE.getCBECommonBaseEvent().getEAllStructuralFeatures();
//		
//		Vector attributesV = new Vector();			
//		if (tempList.size()>0)
//		{
//			for (int i=0;i<tempList.size();i++)
//			{
//				String attrStr = (String)(tempList.get(i));
//				EStructuralFeature feature = findFeatureInList(attrStr, featureList);
//				if (feature != null)
//					attributesV.addElement(new FilterAttribute(feature, attrStr));	 
//			}
//		}
//		CBEPackage.eINSTANCE.getCBECommonBaseEvent_CreationTime()
//		CBEPackage.eINSTANCE.getCBECommonBaseEvent_CreationTime()
//		
//		_attributes = new FilterAttribute[attributesV.size()];
//		attributesV.toArray(_attributes);
//	}
//	
//	private EStructuralFeature findFeatureInList(String name, List featureList){
//		
//		int s = featureList.size();
//		for(int i=0;i<s;i++){			
//			EStructuralFeature attr = (EStructuralFeature) featureList.get(i);
//			if(attr.getName().equalsIgnoreCase((name)))
//				return attr;
//		}
//		return null;
//	}		
}

