/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogRecordPageBook.java,v 1.6 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.log.ui.internal.util.IRecordPaneViewerListener;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.part.*;

public class LogRecordPageBook
	extends PageBook
	implements ISelectionChangedListener, ISelectionProvider, IRecordPaneViewerListener {

	private LogRecordPaneViewer fTableViewer;
	private PCDataPane aPCDataPane;
		
	private LogAnalysisPageBook page;
	private ISelection selection;
	private int selIndex;	

	public LogRecordPageBook(Composite parent, int style) {
		super(parent, style);
		populateUI();
	}
	private void createColumns() {
		Table fTable = (Table) fTableViewer.getControl();
		TableLayout layout = new TableLayout();
		fTable.setLayout(layout);
		fTable.setHeaderVisible(true);
		String headers[] = { LogUIPlugin.getResourceString("RecordPaneHeader1"), LogUIPlugin.getResourceString("RecordPaneHeader2") };
		ColumnLayoutData layouts[] =
			{ new ColumnPixelData(150, true), new ColumnPixelData(300, true)};

		final TableColumn columns[] = new TableColumn[headers.length];
		int ncolumns = 0;

		for (int i = 0; i < headers.length; i++) {
			layout.addColumnData(layouts[i]);
			TableColumn tc = new TableColumn(fTable, SWT.NONE, i);
			tc.setResizable(layouts[i].resizable);
			tc.setText(headers[i]);
			columns[i] = tc;
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (2/23/2001 11:34:19 AM)
	 * @return com.ibm.jface.viewers.TableViewer
	 */
	public TableViewer getTableControl() {
		return fTableViewer;
	}
	protected void populateUI() {
		
		fTableViewer = new LogRecordPaneViewer(this);
		fTableViewer.setContentProvider(new RecordPaneContentProvider());
		fTableViewer.setLabelProvider(new RecordPaneLabelProvider());
		createColumns();
		LogUIPlugin.getDefault().addRecordPaneViewerListener(this);

		aPCDataPane = new PCDataPane(this, SWT.NULL);

		showPage(fTableViewer.getControl());
	}

	public void selectionChanged(SelectionChangedEvent event) {
		try {
			Object singleSelection = null;
			ISelection selection = event.getSelection();
			if(!(selection instanceof IStructuredSelection))
				return;
			singleSelection =((IStructuredSelection)selection).getFirstElement();
				
			selIndex = ((Table)fTableViewer.getControl()).getSelectionIndex();
			fTableViewer.setInput(singleSelection);
									
			showPage(fTableViewer.getControl());

			setSelection();
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void setSelection(){
		
		Object[] elem = ((RecordPaneContentProvider)fTableViewer.getContentProvider()).getElements(fTableViewer.getInput());

		Object newSel = null; 

		if(elem.length>0){
			if(selIndex > -1 && selIndex < elem.length){					
				newSel = elem[selIndex];
			}
			else{					
				selIndex = 0;
				newSel = elem[0];
			}
		}
		else{
			selIndex = -1;
			newSel = new Object[]{null};
		}

		if(selIndex > -1){	
			((Table)fTableViewer.getControl()).setSelection(selIndex);
		}

		selection = new StructuredSelection(newSel);
		SelectionChangedEvent e = new SelectionChangedEvent(this, selection);
		
		page.selectionChanged(e);

	}
	
	/**
	 * Returns the current selection for this provider.
	 * 
	 * @return the current selection
	 */

	public ISelection getSelection(){
		return selection;
	}

	public void handleRecordChangeEvent(RecordChangeEvent event){
		if(event.getType()==RecordChangeEvent.FILTER_COL_CHANGE || event.getType()==RecordChangeEvent.PROPERTY_CHANGE){
			fTableViewer.getControl().setRedraw(false);		
			fTableViewer.refresh();				
			fTableViewer.getControl().setRedraw(true);					
			setSelection();
		}
		
	}
	
	/**
	 * Sets the current selection for this selection provider.
	 *
	 * @param selection the new selection
	 */
	public void setSelection(ISelection selection){
		this.selection = selection;
	}
	
	public void addSelectionChangedListener(ISelectionChangedListener listener) {
		fTableViewer.addSelectionChangedListener(listener);
	}
	
	public void removeSelectionChangedListener(ISelectionChangedListener listener) {
		fTableViewer.removeSelectionChangedListener(listener);
	}
	
	public void setAnalysisPageBook(LogAnalysisPageBook page){
		this.page = page;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Widget#dispose()
	 */
	public void dispose() {
		LogUIPlugin.getDefault().removeRecordPaneViewerListener(this);
		super.dispose();
	}

}