/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogRecordPaneViewer.java,v 1.4 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

public class LogRecordPaneViewer extends TableViewer {

	protected LogRecordPaneViewer inst = null;

	public LogRecordPaneViewer(Composite parent) {
		super(parent, SWT.FULL_SELECTION);

		// cashing the instance for use in inner class
		inst = this;
	}
	public void fillContextMenu(IMenuManager menu) {

		// all selections have this menu item
		menu.add(new Separator());
		menu.add(new Action("[ No analyzers recognized...]") {
			public void run() {
				//refresh();				
			}
			public boolean isEnabled() {
				return true;
			}
		});
		menu.add(new Separator());

	}
}