/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PCDataPane.java,v 1.5 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.widgets.*;

public class PCDataPane extends ViewForm {

	private Text aText1 = null;

	public PCDataPane(Composite parent, int style) {
		super(parent, style);
		createControl(parent);
	}
	
	public void appendText(String pcdata) {
		try {
			aText1.append(pcdata);
		} catch (Exception e) {
			
			e.printStackTrace();
		}
	}
	public Control createControl(Composite parent) {
		aText1 = null;

		Composite result = new Composite(parent, SWT.NONE);

		aText1 = new Text(result, SWT.H_SCROLL | SWT.V_SCROLL | SWT.MULTI | SWT.BORDER);
		aText1.setLayoutData(GridUtil.createFill());

		return result;
	}
	public void setText(String pcdata) {
		try {
			aText1.setText(pcdata);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}