/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecordPaneContentProvider.java,v 1.13 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ColumnData;
import org.eclipse.hyades.log.ui.internal.util.FeatureNode;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.RecordTableElement;
import org.eclipse.hyades.log.ui.internal.util.TreeNode;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEExtendedDataElement;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

/**
 * This class is used for displaying attributes of Common Base Event Model objects
 * i.e properties of log records
 */
public class RecordPaneContentProvider
	implements IStructuredContentProvider {

		

	public void dispose() {		
	}

	public Object getElementAt(Object rowElement, int index) {
		if (rowElement instanceof CBEExtendedDataElement) {

			switch (index) {
				case 0 :
					return ((CBEExtendedDataElement) rowElement).getName();
				case 1 :
					if(((CBEExtendedDataElement) rowElement).getValues().size() > 0)				
						return ((CBEExtendedDataElement) rowElement).getValues().get(0).toString();
			}
		}
		return "unknown row element";
	}
	// ******* IStructuredContentProvider method implementations *******

	public Object[] getElements(Object element) {


		ArrayList elements = new ArrayList();

		if (element instanceof EObject && ((EObject)element).eClass().getEPackage()==CBEPackage.eINSTANCE){
			
			elements.addAll(getEObjectAttributes((EObject)element));
		}
		else
		if(element instanceof FeatureNode && ((FeatureNode) element).getElement() instanceof CorrelationEngine){
			elements.addAll(getEObjectAttributes(((FeatureNode) element).getElement()));	
		}else if(element instanceof TreeNode && ((TreeNode)element).getParent() instanceof CorrelationEngine){
			elements.addAll(getEObjectAttributes(((TreeNode) element).getParent()));
		}
		return elements.toArray();

	}

	/**
	 * Method getEObjectAttributes.
	 * @param object
	 * @return List
	 */
	private List getEObjectAttributes(EObject object) {
		List list = new ArrayList();
		
		EClass eClass = ((EObject)object).eClass();
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		List columns =
			ColumnData.createColumnDataFromString(
				store.getString(LogUIConstants.PD_FILTER_OPTIONS));
		List visibleColumns = new ArrayList();
		

		String visibleCol = "";
		EList attributes = eClass.getEAllAttributes();
		for (int idx = 0; idx < columns.size(); idx++)
		{
			ColumnData data = (ColumnData) columns.get(idx);
			if (data.visible()) {
				
				visibleCol = data.name().toLowerCase();
				EAttribute attribute = findAttributeInList(visibleCol, attributes);
				if(attribute!=null){
					try {
						Object value = object.eGet(attribute);
						if(attribute.getName().equals("creationTime")){
							value = CBEUtils.formatCreationTime((CBECommonBaseEvent)object, LogUIPlugin.getDateTimeFormat());
						}

						if(attribute.isMany() && attribute.getEType().getInstanceClass() == String.class){
							int index = 0;
							for (Iterator iter1 = ((EList)object.eGet(attribute)).iterator(); iter1.hasNext();) {
								RecordTableElement elem = new RecordTableElement(attribute.getName() + "["+ index++ +"]", (String)iter1.next());
								list.add(elem);		
							}

						}
						else
						{
							RecordTableElement elem = new RecordTableElement(attribute.getName(), value!=null ? value.toString():"");
							list.add(elem);		
						}
					} catch (Exception e) {
						//ignore attribute
					}

				}
				
			}
		}
				
		return list;
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	}
	public boolean isDeleted(Object element) {

		return false;
	}
	private String getFirstLine(String input) {
		String firstLine = "";
		char charArray[] = input.toCharArray();
		int found = -1;

		for (int idx = 0; idx < charArray.length; idx++) {
			if ((charArray[idx] == '\r')
				|| (charArray[idx] == '\n')
				|| (charArray[idx] == '\f')) {
				found = idx;
				break;
			}
		}

		if ((found > -1) && (found != 0)) {
			firstLine = input.substring(0, found);
		} else {
			firstLine = input;
		}

		return firstLine;
	}

	
	private EAttribute findAttributeInList(String name, EList attributeList){
		
		for(int i=0;i<attributeList.size();i++){			
			EAttribute attr = (EAttribute) attributeList.get(i);
			if(attr.getName().toLowerCase().equals(name))
				return attr;
		}
		return null;
	}

}