/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecordPaneLabelProvider.java,v 1.5 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.log.ui.internal.util.*;
import org.eclipse.hyades.models.cbe.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.graphics.*;
import java.util.*;

/**
* This class is used for displaying both the TRCProperty entries under TRCDefaultEvents
* and TRCRecordField entries under TRCLogRecords (no cganges needed to support this!)
*/
public class RecordPaneLabelProvider
	extends LabelProvider
	implements ITableLabelProvider {

	public Image getColumnImage(Object element, int columnIndex) {
		// value here was already set by the Table ContentProvider to String 
		if (columnIndex == 0) // && (element instanceof String) ) 
			return LogUIPluginImages.getImage(LogUIPluginImages.RECORD_FIELD);
		else
			return null;
	}
	public Image getColumnImage(Viewer viewer, Object element, int columnIndex) {
		return getColumnImage(element, columnIndex);
	}
	/*
	 * Replaces all sequences of consecutive non-space (' ') whitespace
	 * with a single space. Example: "one\r\ntwo  three" -> "one two  three".
	 */
	public String getColumnText(Object element, int columnIndex) {
		String rawText = getRawColumnText(element, columnIndex);
		StringBuffer buf = new StringBuffer(rawText.length());
		StringTokenizer tok = new StringTokenizer(rawText, "\r\n\t");
		while (tok.hasMoreTokens())
			  buf.append(tok.nextToken() + (tok.hasMoreTokens() ? " " : ""));
		return buf.toString();
	}
	private String getRawColumnText(Object element, int columnIndex) {
		if (element instanceof RecordTableElement) {
			if (columnIndex == 0)
				return ((RecordTableElement) element).getName();
			else if (columnIndex == 1)
				return ((RecordTableElement) element).getValue();
		}

		if (element instanceof String) {
			// value here was already set by the Table ContentProvider 
			return (String) element;
		}

		if (element instanceof CBEExtendedDataElement) {
			if (columnIndex == 0)
				return ((CBEExtendedDataElement) element).getName();
			else if (columnIndex == 1)
			{
				if(((CBEExtendedDataElement) element).getValues().size() > 0)
					return ((CBEExtendedDataElement) element).getValues().get(0).toString();
			}
		}

		return LogUIPlugin.getResourceString("UNKNOWN_LABEL");
	}
	public String getColumnText(Viewer viewer, Object element, int columnIndex) {
		return getColumnText(element, columnIndex);
	}
}