/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImportWizardCheckBox.java,v 1.6 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/**
 * 
 */
public class ImportWizardCheckBox implements IImportWizardWidget, Listener {
	
	protected Button checkBox;
	private ParserField _field = null;


	/**
	 * Constructor
	 * 
	 * @param field - The parser field used to create this object 
	 */
	public ImportWizardCheckBox (ParserField field)
	{
		_field = field;
	}
	
	
	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#getValue()
	 */
	public String getValue() {
		return (checkBox.getSelection() ? "true": "false");
	}
	
	public void setValue(String newValue){
		checkBox.setSelection(newValue.equals("true"));
	}

	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#createControl(Composite, ParserField, String)
	 */
	public void createControl(
		Composite composite,
		String prefix) {
        Label label = new Label(composite, SWT.NULL | SWT.WRAP);            
        GridData data = new GridData();
        data.widthHint = 400;
        data.horizontalSpan = 2;            
        label.setLayoutData(data);
        label.setText(_field.getName());
        
		checkBox = new Button(composite, SWT.CHECK | SWT.LEFT);
		checkBox.setToolTipText(_field.getTooltip());

        checkBox.addListener(SWT.Selection, this);
        
        
        boolean defaultValue = true;
        
		if (_field.getDefaultValue() != null && _field.getDefaultValue().equalsIgnoreCase("false"))
			defaultValue = false;
		
		checkBox.setSelection(defaultValue);			
        /* 
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();            
        String previousValue = store.getString(prefix + field.getId());        
        if (previousValue != null && previousValue.trim().equalsIgnoreCase("false"))
        	defaultValue = false; */
              
	}

	/**
	 * Returns the checkBox.
	 * @return Button
	 */
	public Button getCheckBox() {
		return checkBox;
	}

	/**
	 * Sets the checkBox.
	 * @param checkBox The checkBox to set
	 */
	public void setCheckBox(Button checkBox) {
		this.checkBox = checkBox;
	}


	/**
	 * @see org.eclipse.swt.widgets.Listener#handleEvent(Event)
	 */
	public void handleEvent(Event event) {
	}

	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#isValid()
	 */
	public boolean isValid() {
		return true;
	}
	
	/**
	 * Returns the parser field used to instantiate an object of this class
	 *
	 */
	public ParserField getField()
	{
		return _field;
	}

}
