/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogFileElement.java,v 1.6 2005/03/24 17:56:25 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Aug 7, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;

/**
 * @author apnan
 *
 */
public class LogFileElement {

	private String host;
	private int port;
	private String project;    
	private String monitor;
	private TRCAgentProxy mergedAgent;
	private List values = new ArrayList();
	private LogParserItem parser;
	private boolean isValid;
	private boolean useLargeLogSupport;
	private Filter filter;
	private String tempAdapterPath;
	
	/**
	 * 
	 */
	public LogFileElement() {
		super();

	}

	/**
	 * @return
	 */
	public TRCAgentProxy getMergedAgent() {
		return mergedAgent;
	}

	/**
	 * @return
	 */
	public String getMonitor() {
		return monitor;
	}

	/**
	 * @return
	 */
	public String getProject() {
		return project;
	}

	/**
	 * @return
	 */
	public List getValues() {
		return values;
	}
	
	public Filter getFilter(){
		return filter;
	}

	public void setFilter(Filter newFilter){
		filter = newFilter;
	}
	/**
	 * @param proxy
	 */
	public void setMergedAgent(TRCAgentProxy proxy) {
		mergedAgent = proxy;
	}

	/**
	 * @param string
	 */
	public void setMonitor(String string) {
		monitor = string;
	}

	/**
	 * @param string
	 */
	public void setProject(String string) {
		project = string;
	}


	/**
	 * @return
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @param string
	 */
	public void setHost(String string) {
		host = string;
	}

	/**
	 * @return
	 */
	public LogParserItem getParser() {
		return parser;
	}

	/**
	 * @param item
	 */
	public void setParser(LogParserItem item) {
		parser = item;
	}

	/**
	 * @return
	 */
	public boolean isValid() {
		return isValid;
	}

	/**
	 * @param b
	 */
	public void setValid(boolean b) {
		isValid = b;
	}

	/**
	 * @return Returns the useLargeLogSupport.
	 */
	public boolean isUseLargeLogSupport() {
		return useLargeLogSupport;
	}

	/**
	 * @param useLargeLogSupport The useLargeLogSupport to set.
	 */
	public void setUseLargeLogSupport(boolean useLargeLogSupport) {
		this.useLargeLogSupport = useLargeLogSupport;
	}

	/**
	 * @return Returns the port.
	 */
	public int getPort() {
		return port;
	}
	/**
	 * @param port The port to set.
	 */
	public void setPort(int port) {
		this.port = port;
	}
	
	public String getTempAdapterPath(){
		return tempAdapterPath;
	}
	
	public void setTempAdapterPath(String newValue){
		tempAdapterPath = newValue;
	}
	
	class Filter{
		private String name;
		private String type;
		private SimpleSearchQuery query;
				
		Filter(){			
		}
		
		Filter(String name, String type){
			this.name = name;
			this.type = type;
		}
		
		Filter(String name, String type, SimpleSearchQuery query){
			this.name = name;
			this.type = type;
			this.query = query;
		}

		String getName(){
			return name;
		}
		
		String getType(){
			return type;
		}
		
		SimpleSearchQuery getQuery(){
			return query;
		}
		
		void setName(String newName){
			name = newName;
		}
		
		void setType(String newType){
			type = newType;
		}
		
		void setQuery(SimpleSearchQuery newQuery){
			query = newQuery;
		}
	}
}
