/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogFilterUI.java,v 1.6 2005/04/18 17:51:10 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.internal.core.ImportFilterUI;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class LogFilterUI implements Listener {

	private ImportFilterUI filterUI;
	private ImportLogWizardPage page;
		
	public LogFilterUI(ImportLogWizardPage page){
		this.page = page;
	}
	public Composite createControl(Composite parent) {
		GridLayout layout;

		Composite btnGroup = new Composite(parent, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 0;
		btnGroup.setLayout(layout);
		btnGroup.setLayoutData(GridUtil.createFill());

		filterUI = new ImportFilterUI(getFilterScope());
		filterUI.createControl(btnGroup);

		Label space = new Label(btnGroup, SWT.NONE);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);

		return btnGroup;        
	 }

	public void handleEvent(Event event) {
	}

	public void initialize(){
	}
	
	public void initializeUIFromLogElement(LogFileElement element){
		if(element.getFilter()!=null){
			filterUI.setSelectedFilter(element.getFilter().getName(), element.getFilter().getType());
		}
	}
	
			
	public boolean isTabItemComplete(){
		return true;
	}
	
	public boolean finish(){
		if(filterUI.getSelectedFilter()!=null){
			LogFileElement element = page.getSelectedElement();
			LogFileElement.Filter filter = element.new Filter();
			filter.setName(filterUI.getSelectedFilterName());
			filter.setType(filterUI.getSelectedFilterType());
			filter.setQuery(filterUI.getSelectedFilter());
			element.setFilter(filter);
		}else{
			LogFileElement element = page.getSelectedElement();
			element.setFilter(null);
		}
		return true;
	}	
	
	private String getFilterScope()
	{
		return HyadesConstants.IMPORT_LOG_FILTER_SCOPE;
	}
}
