/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogHostUI.java,v 1.5 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
/*
 * Created on Aug 5, 2003
 *
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceHostUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.TableItem;

/**
 * @author apnan
 * 
 */
public class LogHostUI extends TraceHostUI {
	
	/**
	 * @param wp
	 */
	public LogHostUI(WizardPage wp) {
		super(wp);		
	}

	/**
	 * 
	 */
	public LogHostUI() {
		super();
	}
	public void widgetSelected(SelectionEvent e){
		super.widgetSelected(e);
		//LogFileElement element = ((ImportLogWizardPage) getWizardPage()).getSelectedElement();
		//element.setHost(getHost());
		((ImportLogWizardPage)getWizardPage()).getDialog().setOKButtonEnabled(isTabItemComplete());
		((ImportLogWizardPage)getWizardPage()).initLocation();
	}
	
	public void initialize(LogFileElement element){	
			
		String host = element.getHost();
		int port = element.getPort();
		if(host!=null){
			selectHost(host, port);		
		}
	}

	public boolean isTabItemComplete(){
		return getHost()!=null;
	}
	
	public void selectHost(String hostname, int port)
	{
		if(port==0){
			port = Constants.CTL_PORT_NUM_SERVER;
		}
		super.selectHost(hostname+":"+port);

	}
	
	public boolean finish() {
		
		LogFileElement element = ((ImportLogWizardPage) getWizardPage()).getSelectedElement();
		element.setHost(getHost());
		element.setPort(getPort());
		
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();

		String hosts = "";

		TableItem[] items = getHosts();
		
		if(items.length==0){
			return false;
		}
		
		for (int idx = 0; idx < items.length; idx++) {
			hosts += "," + items[idx].getText().trim();
		}

		if (hosts.startsWith(",") && hosts.length() > 1)
			hosts = hosts.substring(1);

		store.setValue(HyadesConstants.HOST_KEY, hosts);
		
		return true;

	}
}
