/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogParserItem.java,v 1.10 2005/06/08 15:43:10 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.logging.parsers.IParser;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.hyades.log.ui.internal.*;

public class LogParserItem {
    private String _id = "";
    private String _name = "";
    private String _uiName = "_unknown";
    private String _desc = "";
    private ImageDescriptor _imgDesc;
    private String _class = "";
    private String _uiType = "text_field";    
    private ArrayList _parserFields = new ArrayList();
    private IConfigurationElement _config;
	private ArrayList _parserParameters = new ArrayList();

	/**
	 * Stores the widgets of this page
	 * Key = Widget ; Value = Listener
	 */
	private Map _widgets;
	
	/**
	 * Keeps tracks of the listeners that _widgets have been sent to.
	 * Stores the hashCode() of the listener object.
	 */
	private Vector _listenersServed;
	
	
    public LogParserItem(String id, String name, String uiName, String desc) {
        if (id != null)
            _id = id;
        if (name != null)
            _name = name;
        if (uiName != null)
            _uiName = uiName;

        if (desc != null)
            _desc = desc;
    }

    public void setImageDescriptor(ImageDescriptor imgDesc) {
        _imgDesc = imgDesc;
    }

    public void setClass(String cls) {
        if (cls != null)
            _class = cls;
    }

    public void setUIType(String type) {
        if (type != null)
            _uiType = type;
    }

    public void addEntry(ParserField field) {
        _parserFields.add(field);
    }

    public String getName() {
        return _name;
    }

    public String getUIType() {
        return _uiType;
    }

    public String getUIName() {
        return _uiName;
    }

    public String getDescription() {
        return _desc;
    }

    public ImageDescriptor getImageDescriptor() {
        return _imgDesc;
    }

    public ArrayList getFields() {
        return _parserFields;
    }

    public String getId() {
        return _id;
    }

    public String getParserClass() {
        return _class;
    }

    public Parser getParserInstance() {
        try {

            if (_config == null)
                return null;

            Object elem = _config.createExecutableExtension("class");
            if (elem instanceof IParser) {

                return (Parser) elem;

            }
            else {
                System.err.println(LogUIPlugin.getResourceString("LOG_PARSER_ERROR"));
            }
        }
        catch (CoreException exc) {
            return null;
        }

        return null;

    }

    public void setConfigurationElement(IConfigurationElement elem) {
        _config = elem;
    }
    
	/**
	 * Sets the widgets of this page
	 * 
	 * @param widgets - The widgets of the Location wizard page
	 */
	public void setWidgets (Map widgets)
	{
		_widgets = widgets;
	}
	
	
	/**
	 * Retunrs the widgets of this page
	 *
	 * @return The widgets of 'Location' wizard page 
	 */
	public Map getWidgets ()
	{
		return _widgets;
	}
	
	
	/**
	 * Sets the listeners that widgets of this page have been sent to.
	 * 
	 * @param listenersServed - The listeners that have received the widgets of the Location wizard page 
	 */
	public void setListenersServed(Vector listenersServed)
	{
		_listenersServed = listenersServed;
	}
	
	
	/**
	 * Return the listeners that widgets of this page have been sent to.
	 * 
	 * @return The listeners that the widgets of this page have been sent to
	 */
	public Vector getListenersServed()
	{
		return _listenersServed;
	}

	public ArrayList getParserParameters() {
		return _parserParameters;
	}
	public void addParameter(ParserParameter para) {
		_parserParameters.add(para);
	 }
	
	public String getNamespace(){        
		if(_config.getDeclaringExtension()!=null){
			return _config.getDeclaringExtension().getNamespace(); 
		}
		return null;
	}
}
