/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NewCorrelationWizard.java,v 1.8 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Nov 20, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.logc.internal.util.CorrelationHelper;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.trace.internal.ui.PDPerspective;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.HyadesUI;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/**
 * @author apnan
 */
public class NewCorrelationWizard extends Wizard implements INewWizard {

	protected LogSelectionWizardPage selPage;
	protected CorrelationSelectionWizardPage corrPage;
	private IStructuredSelection sel;
	protected CorrelationContainerProxy correlationContainerProxy;
	private IWorkbench workbench;	
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish() {
		
		BusyIndicator.showWhile(Display.getDefault(), new Runnable(){	
			public void run(){
				List agentsList = selPage.getLogFiles();
				correlationContainerProxy = CorrelationHelper.getInstance().createCorrelationContainer(corrPage.getCorrelation(),  selPage.getLogFiles(), selPage.getName());

			}			
		});
			
		if(correlationContainerProxy!=null){
			
			try {
				IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
				/* find out if the perspective should change */
    			
				boolean shouldSwitch= false;
				IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    	        shouldSwitch = HyadesUIPlugin.getInstance().openPerspectiveSwitchDialog(
    	        				window.getShell(), PDPerspective.ID_TRACE_PERSPECTIVE,
    	        				UIPlugin.getDefault().getPreferenceStore(), 
    	        				HyadesUI.SWITCH_TO_PERSPECTIVE_KEY, 
    							LogUIPlugin.getResourceString("CONFIRM_PERSP_SWITCH_MSG"));
    		    
    	        
				if(shouldSwitch && page != null && !page.getPerspective().getId().equals(PDPerspective.ID_TRACE_PERSPECTIVE) ){
					IAdaptable element =
					ResourcesPlugin.getWorkspace().getRoot();
					if (element != null)
						page =
							workbench.showPerspective(
								PDPerspective.ID_TRACE_PERSPECTIVE,
								workbench.getActiveWorkbenchWindow(),
								element);
    	        }
				if (page != null && PDPerspective.ID_TRACE_PERSPECTIVE.equals(page.getPerspective().getId())) {					
					final IViewPart part = page.showView(PDPerspective.ID_LOG_NAVIGATOR_VIEW);
					if(part!=null){
										
						Display.getDefault().asyncExec(new Runnable()
						{
							public void run()
							{
								((LogNavigator)part).selectReveal(new StructuredSelection(correlationContainerProxy));
							}
						});						
					}
				}
			} catch (Exception e) {				
				LogUIPlugin.log(e);
			}
		}
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		store.setValue("corr_nr",store.getInt("corr_nr")+1);
		
		return true;	
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		sel = selection;
		this.workbench = workbench;		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages() {


		setWindowTitle(LogUIPlugin.getResourceString("STR_NEW_CORR_WIZARD_TITLE"));
		super.addPages();
		selPage = new LogSelectionWizardPage(LogUIPlugin.getResourceString("STR_NEW_CORR_WIZARD_TITLE"), sel);
		addPage(selPage);
			
		corrPage = new CorrelationSelectionWizardPage(LogUIPlugin.getResourceString("STR_NEW_CORR_WIZARD_TITLE"), CorrelationHelper.getInstance().getCorrelationExtensions());
		addPage(corrPage);		
	}
	
}
